/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.ncc.NccGuiOptions;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class NCCTab
extends PreferencePanel {
    private JTextField absoluteSizeTolerance;
    private JCheckBox backAnnotateLayNetNamesFromSch;
    private JPanel checkingAllCells;
    private JCheckBox enableSizeChecking;
    private JPanel errorReport;
    private JRadioButton flatTop;
    private JCheckBox haltAfterFindingFirstMismatchedCell;
    private JRadioButton hierAll;
    private JTextField howMuchStatus;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel75;
    private JLabel jLabel76;
    private JRadioButton listAnn;
    private JTextField maxMatched;
    private JTextField maxMembers;
    private JTextField maxMismatched;
    private JPanel misc;
    private JPanel ncc;
    private JPanel operation;
    private ButtonGroup operationGroup;
    private JPanel progressReport;
    private JTextField relativeSizeTolerance;
    private JPanel sizeChecking;
    private JCheckBox skipPassed;

    public NCCTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.ncc;
    }

    public String getName() {
        return "NCC";
    }

    private void setOperation(int op) {
        switch (op) {
            case 0: {
                this.hierAll.setSelected(true);
                break;
            }
            case 2: {
                this.flatTop.setSelected(true);
                break;
            }
            case 3: {
                this.listAnn.setSelected(true);
                break;
            }
            default: {
                this.hierAll.setSelected(true);
            }
        }
    }

    private int getOperation() {
        if (this.hierAll.isSelected()) {
            return 0;
        }
        if (this.flatTop.isSelected()) {
            return 2;
        }
        if (this.listAnn.isSelected()) {
            return 3;
        }
        return 0;
    }

    public void init() {
        this.enableSizeChecking.setSelected(NccGuiOptions.getCheckSizes());
        this.relativeSizeTolerance.setText(Double.toString(NccGuiOptions.getRelativeSizeTolerance()));
        this.absoluteSizeTolerance.setText(Double.toString(NccGuiOptions.getAbsoluteSizeTolerance()));
        this.haltAfterFindingFirstMismatchedCell.setSelected(NccGuiOptions.getHaltAfterFirstMismatch());
        this.skipPassed.setSelected(NccGuiOptions.getSkipPassed());
        this.maxMatched.setText(Integer.toString(NccGuiOptions.getMaxMatchedClasses()));
        this.maxMismatched.setText(Integer.toString(NccGuiOptions.getMaxMismatchedClasses()));
        this.maxMembers.setText(Integer.toString(NccGuiOptions.getMaxClassMembers()));
        this.setOperation(NccGuiOptions.getOperation());
        this.howMuchStatus.setText(Integer.toString(NccGuiOptions.getHowMuchStatus()));
        this.backAnnotateLayNetNamesFromSch.setSelected(NccGuiOptions.getBackAnnotateLayoutNetNames());
    }

    public void term() {
        int currInt;
        double currDouble;
        boolean currBoolean = this.enableSizeChecking.isSelected();
        if (currBoolean != NccGuiOptions.getCheckSizes()) {
            NccGuiOptions.setCheckSizes(currBoolean);
        }
        if ((currDouble = TextUtils.atof(this.relativeSizeTolerance.getText(), new Double(NccGuiOptions.getRelativeSizeTolerance()))) != NccGuiOptions.getRelativeSizeTolerance()) {
            NccGuiOptions.setRelativeSizeTolerance(currDouble);
        }
        if ((currDouble = TextUtils.atof(this.absoluteSizeTolerance.getText(), new Double(NccGuiOptions.getAbsoluteSizeTolerance()))) != NccGuiOptions.getAbsoluteSizeTolerance()) {
            NccGuiOptions.setAbsoluteSizeTolerance(currDouble);
        }
        if ((currBoolean = this.haltAfterFindingFirstMismatchedCell.isSelected()) != NccGuiOptions.getHaltAfterFirstMismatch()) {
            NccGuiOptions.setHaltAfterFirstMismatch(currBoolean);
        }
        if ((currBoolean = this.skipPassed.isSelected()) != NccGuiOptions.getSkipPassed()) {
            NccGuiOptions.setSkipPassed(currBoolean);
        }
        if ((currInt = Integer.parseInt(this.maxMatched.getText())) != NccGuiOptions.getMaxMatchedClasses()) {
            NccGuiOptions.setMaxMatchedClasses(currInt);
        }
        if ((currInt = Integer.parseInt(this.maxMismatched.getText())) != NccGuiOptions.getMaxMismatchedClasses()) {
            NccGuiOptions.setMaxMismatchedClasses(currInt);
        }
        if ((currInt = Integer.parseInt(this.maxMembers.getText())) != NccGuiOptions.getMaxClassMembers()) {
            NccGuiOptions.setMaxClassMembers(currInt);
        }
        if ((currInt = this.getOperation()) != NccGuiOptions.getOperation()) {
            NccGuiOptions.setOperation(currInt);
        }
        if ((currInt = Integer.parseInt(this.howMuchStatus.getText())) != NccGuiOptions.getHowMuchStatus()) {
            NccGuiOptions.setHowMuchStatus(currInt);
        }
        if ((currBoolean = this.backAnnotateLayNetNamesFromSch.isSelected()) != NccGuiOptions.getBackAnnotateLayoutNetNames()) {
            NccGuiOptions.setBackAnnotateLayoutNetNames(currBoolean);
        }
    }

    private void initComponents() {
        this.operationGroup = new ButtonGroup();
        this.ncc = new JPanel();
        this.operation = new JPanel();
        this.hierAll = new JRadioButton();
        this.flatTop = new JRadioButton();
        this.listAnn = new JRadioButton();
        this.sizeChecking = new JPanel();
        this.enableSizeChecking = new JCheckBox();
        this.jLabel75 = new JLabel();
        this.jLabel76 = new JLabel();
        this.relativeSizeTolerance = new JTextField();
        this.absoluteSizeTolerance = new JTextField();
        this.checkingAllCells = new JPanel();
        this.haltAfterFindingFirstMismatchedCell = new JCheckBox();
        this.skipPassed = new JCheckBox();
        this.progressReport = new JPanel();
        this.jLabel4 = new JLabel();
        this.howMuchStatus = new JTextField();
        this.errorReport = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.maxMatched = new JTextField();
        this.maxMismatched = new JTextField();
        this.maxMembers = new JTextField();
        this.misc = new JPanel();
        this.backAnnotateLayNetNamesFromSch = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NCCTab.this.closeDialog(evt);
            }
        });
        this.ncc.setLayout(new GridBagLayout());
        this.operation.setLayout(new GridBagLayout());
        this.operation.setBorder(new TitledBorder("Operation"));
        this.hierAll.setText("Hierarchical Comparison");
        this.operationGroup.add(this.hierAll);
        this.hierAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NCCTab.this.hierAllActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.operation.add((Component)this.hierAll, gridBagConstraints);
        this.flatTop.setText("Flat Comparison");
        this.operationGroup.add(this.flatTop);
        this.flatTop.setActionCommand("Flat NCC");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.operation.add((Component)this.flatTop, gridBagConstraints);
        this.listAnn.setText("List NCC annotations");
        this.operationGroup.add(this.listAnn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.operation.add((Component)this.listAnn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.operation, gridBagConstraints);
        this.sizeChecking.setLayout(new GridBagLayout());
        this.sizeChecking.setBorder(new TitledBorder("Size Checking"));
        this.enableSizeChecking.setText("Check transistor sizes");
        this.enableSizeChecking.setActionCommand("Check Transistor Sizes");
        this.enableSizeChecking.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.sizeChecking.add((Component)this.enableSizeChecking, gridBagConstraints);
        this.jLabel75.setText("Relative size tolerance  (%):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.jLabel75, gridBagConstraints);
        this.jLabel76.setText("Absolute size tolerance (units):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.jLabel76, gridBagConstraints);
        this.relativeSizeTolerance.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.relativeSizeTolerance, gridBagConstraints);
        this.absoluteSizeTolerance.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.sizeChecking.add((Component)this.absoluteSizeTolerance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.sizeChecking, gridBagConstraints);
        this.checkingAllCells.setLayout(new GridBagLayout());
        this.checkingAllCells.setBorder(new TitledBorder("Checking All Cells"));
        this.haltAfterFindingFirstMismatchedCell.setText("Halt after finding the first mismatched cell");
        this.haltAfterFindingFirstMismatchedCell.setActionCommand("Halt on First Mismatched Cell");
        this.haltAfterFindingFirstMismatchedCell.setHorizontalTextPosition(10);
        this.checkingAllCells.add((Component)this.haltAfterFindingFirstMismatchedCell, new GridBagConstraints());
        this.skipPassed.setText("Don't recheck cells that have passed in this Electric run");
        this.skipPassed.setHorizontalTextPosition(10);
        this.skipPassed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NCCTab.this.skipPassedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.checkingAllCells.add((Component)this.skipPassed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.checkingAllCells, gridBagConstraints);
        this.progressReport.setLayout(new GridBagLayout());
        this.progressReport.setBorder(new TitledBorder("Reporting Progress"));
        this.jLabel4.setText("How many status messages to print (0->few, 2->many):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.progressReport.add((Component)this.jLabel4, gridBagConstraints);
        this.howMuchStatus.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        this.progressReport.add((Component)this.howMuchStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.progressReport, gridBagConstraints);
        this.errorReport.setLayout(new GridBagLayout());
        this.errorReport.setBorder(new TitledBorder("Error Reporting"));
        this.jLabel1.setLabelFor(this.maxMatched);
        this.jLabel1.setText("Maximum number of matched equivalence classes to print");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.errorReport.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setLabelFor(this.maxMismatched);
        this.jLabel2.setText("Maximum number of mismatched equivalence classes to print");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.errorReport.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setLabelFor(this.maxMembers);
        this.jLabel3.setText("Maximum number of equivalence class members to print");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.errorReport.add((Component)this.jLabel3, gridBagConstraints);
        this.maxMatched.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.errorReport.add((Component)this.maxMatched, gridBagConstraints);
        this.maxMismatched.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.errorReport.add((Component)this.maxMismatched, gridBagConstraints);
        this.maxMembers.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.errorReport.add((Component)this.maxMembers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.errorReport, gridBagConstraints);
        this.misc.setLayout(new GridBagLayout());
        this.misc.setBorder(new TitledBorder("Miscellaneous"));
        this.backAnnotateLayNetNamesFromSch.setHorizontalTextPosition(10);
        this.backAnnotateLayNetNamesFromSch.setText("Back-annotate layout nets with schematic net names after matching");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.misc.add((Component)this.backAnnotateLayNetNamesFromSch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.ncc.add((Component)this.misc, gridBagConstraints);
        this.misc.getAccessibleContext().setAccessibleName("Miscellaneous");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.ncc, gridBagConstraints);
        this.pack();
    }

    private void hierAllActionPerformed(ActionEvent evt) {
    }

    private void skipPassedActionPerformed(ActionEvent evt) {
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

