/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.utils;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.plugins.j3d.utils.J3DUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class J3DAppearance
extends Appearance
implements Observer {
    private static final HashMap graphics3DTransModePrefs = new HashMap();
    private static final HashMap graphics3DTransFactorPrefs = new HashMap();
    private static final int JAPP_DEFAULT_MODE = 4;
    private static final float JAPP_DEFAULT_FACTOR = 0.2f;
    private EGraphics graphics;
    public static J3DAppearance cellApp;
    public static J3DAppearance highligtApp;
    public static J3DAppearance[] axisApps;

    public J3DAppearance(J3DAppearance app) {
        if (app == null) {
            throw new Error("Input appearance is null");
        }
        this.graphics = app.graphics;
        if (this.graphics != null) {
            this.graphics.addObserver(this);
        }
        TransparencyAttributes oldTa = app.getTransparencyAttributes();
        this.setOtherAppearanceValues(oldTa.getTransparencyMode(), oldTa.getTransparency(), this.graphics.getColor());
    }

    private J3DAppearance(EGraphics graphics, int mode, float factor, Color color) {
        this.graphics = graphics;
        if (graphics != null) {
            graphics.addObserver(this);
        }
        this.setOtherAppearanceValues(mode, factor, color);
    }

    public void setGraphics(EGraphics graphics) {
        this.graphics = graphics;
        if (graphics != null) {
            graphics.addObserver(this);
        }
    }

    public EGraphics getGraphics() {
        return this.graphics;
    }

    private void setOtherAppearanceValues(int mode, float factor, Color color) {
        TransparencyAttributes ta = new TransparencyAttributes(mode, factor);
        ta.setCapability(2);
        ta.setCapability(3);
        ta.setCapability(0);
        ta.setCapability(1);
        this.setTransparencyAttributes(ta);
        this.setCapability(10);
        this.setCapability(11);
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(12);
        this.setCapability(13);
        if (this.graphics != null) {
            RenderingAttributes ra = new RenderingAttributes();
            ra.setCapability(5);
            ra.setCapability(6);
            ra.setCapability(4);
            ra.setCapability(11);
            ra.setVisible(this.graphics.getLayer().isVisible());
            this.setRenderingAttributes(ra);
            if (mode != 4) {
                ra.setDepthBufferEnable(true);
            }
        }
        if (color != null) {
            Color3f objColor = new Color3f(color);
            Material mat = new Material(objColor, J3DUtils.black, objColor, J3DUtils.plastic, 17.0f);
            mat.setLightingEnable(true);
            mat.setCapability(0);
            mat.setCapability(1);
            mat.setCapability(4);
            this.setMaterial(mat);
        }
    }

    public static void setCellVisibility(boolean value) {
        cellApp.getRenderingAttributes().setVisible(value);
    }

    public static J3DAppearance getAppearance(EGraphics graphics) {
        J3DAppearance ap = (J3DAppearance)graphics.get3DAppearance();
        if (ap == null) {
            int mode = graphics.getLayer().getIntegerPref("3DTransparencyMode", graphics3DTransModePrefs, 4).getInt();
            float factor = (float)graphics.getLayer().getDoublePref("3DTransparencyFactor", graphics3DTransFactorPrefs, 0.2f).getDouble();
            ap = new J3DAppearance(graphics, mode, factor, graphics.getColor());
            graphics.set3DAppearance(ap);
        }
        return ap;
    }

    public void setTransparencyAndRenderingAttributes(TransparencyAttributes transparencyAttributes, boolean rendering) {
        super.setTransparencyAttributes(transparencyAttributes);
        super.getRenderingAttributes().setDepthBufferEnable(rendering);
        int mode = transparencyAttributes.getTransparencyMode();
        this.graphics.getLayer().getIntegerPref("3DTransparencyMode", graphics3DTransModePrefs, mode).setInt(mode);
        double factor = transparencyAttributes.getTransparency();
        this.graphics.getLayer().getDoublePref("3DTransparencyFactor", graphics3DTransFactorPrefs, factor).setDouble(factor);
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof Boolean) {
            this.set3DVisibility((Boolean)arg);
        }
    }

    private void set3DVisibility(Boolean visible) {
        if (this.getRenderingAttributes() == null || visible == null) {
            System.out.println("Error in J3DAppearance.set3DVisibility");
        } else {
            this.getRenderingAttributes().setVisible(visible.booleanValue());
        }
    }

    public void set3DColor(Object material, Color color) {
        Material mat = material == null ? this.getMaterial() : (Material)material;
        Color3f objColor = new Color3f(color);
        mat.setDiffuseColor(objColor);
        mat.setAmbientColor(objColor);
        if (this.getColoringAttributes() != null) {
            this.getColoringAttributes().setColor(objColor);
        }
    }

    public static void setAxisAppearanceValues(Object initValue) {
        double[] colors = J3DUtils.transformIntoValues(J3DUtils.get3DColorAxes());
        for (int i = 0; i < axisApps.length; ++i) {
            Color userColor = new Color((int)colors[i]);
            if (axisApps[i] == null) {
                J3DAppearance.axisApps[i] = new J3DAppearance(null, 4, 0.5f, userColor);
                PolygonAttributes polygonAttributes = new PolygonAttributes();
                polygonAttributes.setCullFace(0);
                LineAttributes lineAttributes = new LineAttributes();
                lineAttributes.setLineWidth(3.0f);
                ColoringAttributes colorAttrib = new ColoringAttributes();
                colorAttrib.setColor(new Color3f(userColor));
                colorAttrib.setCapability(0);
                colorAttrib.setCapability(1);
                axisApps[i].setColoringAttributes(colorAttrib);
                axisApps[i].setPolygonAttributes(polygonAttributes);
                axisApps[i].setLineAttributes(lineAttributes);
                axisApps[i].setCapability(8);
                axisApps[i].setCapability(9);
                RenderingAttributes ra = new RenderingAttributes();
                ra.setCapability(5);
                ra.setCapability(6);
                ra.setVisible(J3DUtils.is3DAxesOn());
                axisApps[i].setRenderingAttributes(ra);
                continue;
            }
            if (initValue != null) continue;
            axisApps[i].set3DColor(null, userColor);
        }
    }

    public static void setHighlightedAppearanceValues(Object initValue) {
        Color userColor = new Color(J3DUtils.get3DColorHighlighted());
        if (highligtApp == null) {
            highligtApp = new J3DAppearance(null, 2, 0.5f, userColor);
        } else if (initValue == null) {
            highligtApp.set3DColor(null, userColor);
        }
    }

    public static void setCellAppearanceValues(Object initValue) {
        Color3f userColor = new Color3f(new Color(J3DUtils.get3DColorInstanceCell()));
        if (cellApp == null) {
            cellApp = new J3DAppearance(null, 3, 0.0f, null);
            RenderingAttributes ra = new RenderingAttributes();
            ra.setCapability(5);
            ra.setCapability(6);
            ra.setVisible(J3DUtils.is3DCellBndOn());
            cellApp.setRenderingAttributes(ra);
            PolygonAttributes pa = new PolygonAttributes();
            pa.setCullFace(0);
            pa.setPolygonMode(1);
            cellApp.setPolygonAttributes(pa);
            LineAttributes lineAttr = new LineAttributes();
            lineAttr.setLineAntialiasingEnable(true);
            cellApp.setLineAttributes(lineAttr);
            ColoringAttributes ca = new ColoringAttributes();
            ca.setCapability(1);
            ca.setCapability(0);
            ca.setColor(userColor);
            cellApp.setColoringAttributes(ca);
            cellApp.setCapability(8);
            cellApp.setCapability(9);
        } else if (initValue == null) {
            ColoringAttributes ca = cellApp.getColoringAttributes();
            Color3f curColor = new Color3f();
            ca.getColor(curColor);
            if (!userColor.equals((Tuple3f)curColor)) {
                ca.setColor(userColor);
            }
        }
    }

    static {
        axisApps = new J3DAppearance[3];
    }
}

