;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: CLUEI; Base: 10; Patch-File: T; -*-

(in-package :cluei)

;  method 'destroy' destroys window before unmapping it.  
;  This leads to a window error in the unmap request.
;  The following patch unmaps the window first.

(defmethod destroy ((contact contact))
  "Destroy a contact and all its resources"
  (when (and (not (destroyed-p contact))	; only destroy windows once
	     (contact-parent contact))		; Don't destroy root
    ;; unmanage the contact
    (let ((old-state (contact-state contact)))
      (setf (contact-state contact) :withdrawn) ; *** unmap the window first
      (when (realized-p contact)
	;; Turn ON structure-notify to receive destroy-notify events
	(setf (window-event-mask contact) #.(make-event-mask :structure-notify))
	;; Unmap and Destroy the contact's and children's windows.
	(destroy-window contact))
      ;; Destroy resources
      (map-over-children contact #'destroy-cleanup)
;     ;; unmanage the contact
;     (setf (contact-state contact) :withdrawn)  ; *** not here!
      ;; Delete contact from its parent's child list
      (delete-child (contact-parent contact) contact)
      (unless (eq old-state :withdrawn)
	(change-layout (contact-parent contact)) ; this should be sent by
					         ; (setf (contact-state...)),
	                                         ; but its too soon
	))))

