/*
 *  Ball And Paddle
 *
 *  Copyright (C) 2007 by Eric Hutchins
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **/

#include "mainmenu.h"
#include "optionsmenu.h"
#include "helpscreen.h"
#include "highscoremenu.h"
#include "levelsetmenu.h"

MainMenu
  MainMenu::m_instance;

void
MainMenu::init ()
{
  menuItems.push_back ("Start");
  menuItems.push_back ("Help");
  menuItems.push_back ("Options");
  menuItems.push_back ("High Score");
  menuItems.push_back ("Exit");
  spacing = 40;
  string location = IMAGEPATH + "/menuback.png";
  SDL_Surface *temp = IMG_Load (location.c_str ());
  if (temp != NULL)
    imgBackground = SDL_DisplayFormat (temp);
  SDL_FreeSurface (temp);
  cursor = 0;
}

void
MainMenu::cleanup ()
{
  while (!menuItems.empty ())
    menuItems.pop_back ();
  SDL_FreeSurface (imgBackground);
}

void
MainMenu::pause ()
{
}

void
MainMenu::resume ()
{
}

void
MainMenu::draw (GameStateManager * gameStateManager)
{
  SDL_BlitSurface (imgBackground, NULL, gameStateManager->screen, NULL);
  SDL_Rect r = { 160, 230, 320, 230 };
  SDL_FillRect (gameStateManager->screen, &r,
		SDL_MapRGB (gameStateManager->screen->format, 64, 64, 64));
  for (int i = 0; i < menuItems.size (); i++)
    {
      if (cursor == i)
	gameStateManager->drawStringCentered (FONT_ACTIVE, menuItems[i], 320,
					      250 + i * spacing);
      else
	gameStateManager->drawStringCentered (FONT_INACTIVE, menuItems[i],
					      320, 250 + i * spacing);
    }
}

void
MainMenu::handleEvents (GameStateManager * gameStateManager)
{

  int mouseX;
  int mouseY;

  SDL_Event event;

  while (SDL_PollEvent (&event))
    {
      switch (event.type)
	{
	case SDL_QUIT:
	  gameStateManager->quit ();
	  break;
	case SDL_KEYDOWN:
	  switch (event.key.keysym.sym)
	    {
	    case SDLK_RETURN:
	      handleItem (gameStateManager);
	      break;
	    case SDLK_UP:
	      cursor--;
	      if (cursor < 0)
		cursor = menuItems.size () - 1;
	      gameStateManager->playSound ("hit");
	      break;
	    case SDLK_DOWN:
	      cursor++;
	      if (cursor >= menuItems.size ())
		cursor = 0;
	      gameStateManager->playSound ("hit");
	      break;
	    }
	  break;
	case SDL_MOUSEMOTION:
	  mouseX = event.motion.x;
	  mouseY = event.motion.y;

	  int x1;
	  int x2;
	  for (int i = 0; i < menuItems.size (); i++)
	    {
	      x1 =
		320 -
		menuItems[i].length () *
		gameStateManager->getCharWidth (FONT_INACTIVE) / 2;
	      x2 =
		x1 +
		menuItems[i].length () *
		gameStateManager->getCharWidth (FONT_INACTIVE);
	      if (mouseX >= x1 && mouseX <= x2 && mouseY >= 250 + i * spacing
		  && mouseY <=
		  250 + gameStateManager->getCharHeight (FONT_INACTIVE) +
		  i * spacing)
		cursor = i;
	    }
	  break;
	case SDL_MOUSEBUTTONDOWN:
	  handleItem (gameStateManager);
	  break;
	}
    }

}

void
MainMenu::update (GameStateManager * gameStateManager)
{
}

void
MainMenu::handleItem (GameStateManager * gameStateManager)
{
  switch (cursor)
    {
    case 0:
      gameStateManager->changeState (LevelSetMenu::instance ());
      break;
    case 1:
      gameStateManager->changeState (HelpScreen::instance ());
      break;
    case 2:
      gameStateManager->changeState (OptionsMenu::instance ());
      break;
    case 3:
      gameStateManager->changeState (HighScoreMenu::instance ());
      break;
    case 4:
      gameStateManager->quit ();
      break;
    }
}
