/*  -*- Mode: C -*-  */

/* stream-test.c ---  */

/* Author:	       Gary V. Vaughan <gvv@techie.com>
 * Maintainer:	       Gary V. Vaughan <gvv@techie.com>
 * Created:	       Mon May 10 21:21:24 1999
 * Last Modified:      Wed Jul 14 15:05:59 1999
 *            by:      Gary V. Vaughan <gvv@techie.com>
 * ---------------------------------------------------------------------
 * @(#) $Id$
 * ---------------------------------------------------------------------
 */

/* Copyright (C) 1999 Gary V. Vaughan */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * As a special exception to the GNU General Public License, if you
 * distribute this file as part of a program that also links with and
 * uses the libopts library from AutoGen, you may include it under
 * the same distribution terms used by the libopts library.
 */

/* Code: */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>

#if defined(STDC_HEADERS) || defined(HAVE_STDLIB_H)
#  include <stdlib.h>
#else
extern char *getenv();
#endif

#ifdef HAVE_STRING_H
#  include <string.h>
#else
#  ifdef HAVE_STRINGS_H
#    include <strings.h>
#  else
extern int strncmp();
#  endif
#endif

#include "snprintfv.h"		/* for bufputc() */
#include "snprintfv/stream.h"

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS  0
#  define EXIT_FAILURE  1
#endif

#ifndef EOS
#define EOS '\0'
#endif

#ifndef DIR_SEPARATOR
#define DIR_SEPARATOR '/'
#endif

static int	stream_print	PARAMS((STREAM *stream, char *string));

static const char *progname;

/* Put characters from STRING into STREAM until the the end of the
   string is reached or the stream is full. */
static int
stream_print (stream, string)
    STREAM *stream;
    char *string;
{
    int count = 0;

    while ((string[count] != EOS) && (count >= 0))
    {
	int status = stream_put(string[count], stream);
	if (status < 0)
	{
	    count = status;
	    break;
	}
	count++;
    }

    return count;
}

int
main (argc, argv)
    int   argc;
    char *argv[];
{
    static char string[] = "foo*Fnord";
    FILE *verbose = NULL;
    STREAM *out;
    char buffer[4], *p = buffer;
    int count;

    progname = argv[0] + strlen(argv[0]);
    while (progname > argv[0] && *(progname -1) != DIR_SEPARATOR)
    {
	progname--;
    }

    if (getenv("VERBOSE"))
    {
	verbose = stdout;
    }
    else
    {
	verbose = fopen("/dev/null", "w");
    }
  
    fprintf(verbose, "=== running test %s\n", progname);

    (void)strcpy(buffer, "123");

    /* We can't portably pass the address of the buffer in directly,
       because the bufputc function increments that address after
       each byte is written. */
    out = stream_new((stream_gpointer)&p, 3, NULL, bufputc, NULL);

    count = stream_print(out, string);
    if ((count != EOF) || strncmp(buffer, string, strlen(buffer)))
    {
	return EXIT_FAILURE;
    }
    
    return EXIT_SUCCESS;
}

/* stream-test.c ends here */



