/*
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Lewis Y. Geer
 *
 * File Description:
 *   Contains code for reading in spectrum data sets.
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'omssa.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>
#include <corelib/ncbistd.hpp>
#include <corelib/ncbi_limits.hpp>
#include <corelib/ncbifile.hpp>
#include <connect/ncbi_memory_connector.h>
#include <connect/ncbi_conn_stream.hpp>
#include <serial/serial.hpp>
#include <serial/objistrasn.hpp>
#include <serial/objistrasnb.hpp>
#include <serial/objostrasn.hpp>
#include <serial/objostrasnb.hpp>
#include <serial/iterator.hpp>
#include <serial/objostrxml.hpp>
#include <objects/omssa/omssa__.hpp>

#include "msmerge.hpp"

#include <algorithm>
#include <iterator>

BEGIN_NCBI_SCOPE
BEGIN_SCOPE(objects)
BEGIN_SCOPE(omssa)


void COMSSASearch::CopyCMSSearch(CRef <COMSSASearch> OldSearch)
{
    // SerialAssign(*OldSearch);
    CConn_MemoryStream memory_stream;

{
    CObjectOStreamAsnBinary omemorystream(memory_stream);
    omemorystream << *OldSearch;
    omemorystream.Flush();
}

    CObjectIStreamAsnBinary imemorystream(memory_stream);
    imemorystream >> *this;
}


const string COMSSASearch::FileEnding(const ESerialDataFormat FileType) const 
{
    if(FileType == eSerial_Xml) return "omx";
    else if(FileType == eSerial_AsnBinary) return "oms";
    else if(FileType == eSerial_AsnText) return "omt";
    return "";
}


void 
COMSSASearch::FindMinMaxForOneSetting(
    const CMSSearchSettings& SearchSettings,
    int& Min,
    int& Max
    ) const
{
    if(SearchSettings.GetSettingid() < Min) Min = SearchSettings.GetSettingid();
    if(SearchSettings.GetSettingid() > Max) Max = SearchSettings.GetSettingid();
}
   
void 
COMSSASearch::FindMinMaxSearchSettingId(
    int& Min,
    int& Max
    ) const
{
    Max = numeric_limits <int>::min();
    Min = numeric_limits <int>::max();

    if(GetRequest().size() == 0)
        NCBI_THROW(COMSSAException, eMSParseException, "No Search Requests");

    FindMinMaxForOneSetting((*GetRequest().begin())->GetSettings(), Min, Max);
    if((*GetRequest().begin())->CanGetMoresettings() && (*GetRequest().begin())->GetMoresettings().CanGet()) {
        ITERATE(CMSSearchSettingsSet::Tdata, iSettings, (*GetRequest().begin())->GetMoresettings().Get()) {
            FindMinMaxForOneSetting(**iSettings, Min, Max);
        }
    }
}


void
COMSSASearch::FindMinMaxSpectrumNumber(
    int& Min,
    int& Max
    ) const
{
    Max = numeric_limits <int>::min();
    Min = numeric_limits <int>::max();

    if(GetRequest().size() == 0)
         NCBI_THROW(COMSSAException, eMSParseException, "No Search Requests");

    if((*GetRequest().begin())->GetSpectra().Get().size() == 0)
        NCBI_THROW(COMSSAException, eMSParseException, "No Spectra");

    ITERATE(CMSSpectrumset::Tdata, iSpectrum, (*GetRequest().begin())->GetSpectra().Get()) {
        if((*iSpectrum)->GetNumber() > Max)
            Max = (*iSpectrum)->GetNumber();
        if((*iSpectrum)->GetNumber() < Min)
            Min = (*iSpectrum)->GetNumber();
    }
}

void
COMSSASearch::CopySpectra(CRef <COMSSASearch> OldSearch)
{
    NON_CONST_ITERATE(CMSSpectrumset::Tdata, iSpectrum, (*OldSearch->SetRequest().begin())->SetSpectra().Set()) {
        (*SetRequest().begin())->SetSpectra().Set().push_back(*iSpectrum);
     }
}

void
COMSSASearch::CopyHitsets(CRef <COMSSASearch> OldSearch)
{
    NON_CONST_ITERATE(CMSResponse::THitsets, iHits, (*OldSearch->SetResponse().begin())->SetHitsets()) {
        (*SetResponse().begin())->SetHitsets().push_back(*iHits);
    }
}

void
COMSSASearch::CopySettings(CRef <COMSSASearch> OldSearch)
{
    CRef <CMSSearchSettings> OldSettings (&((*OldSearch->SetRequest().begin())->SetSettings()));
    (*SetRequest().begin())->SetMoresettings().Set().push_back(OldSettings);

     if((*OldSearch->GetRequest().begin())->CanGetMoresettings() && 
        (*OldSearch->GetRequest().begin())->GetMoresettings().CanGet()) {
         NON_CONST_ITERATE(CMSSearchSettingsSet::Tdata, iSettings, (*OldSearch->SetRequest().begin())->SetMoresettings().Set()) {
             (*SetRequest().begin())->SetMoresettings().Set().push_back(*iSettings);
         }
     }
}

const bool 
COMSSASearch::CheckLibraryNameAndSize(const string Name, const int Size) const
{
    if(GetRequest().size() == 0)
          NCBI_THROW(COMSSAException, eMSParseException, "No Search Requests");
    if(GetResponse().size() == 0)
           NCBI_THROW(COMSSAException, eMSParseException, "No Search Responses");


    if((*GetRequest().begin())->GetSettings().GetDb() != Name ||
       (*GetResponse().begin())->GetDbversion() != Size)
        return false;

    if((*GetRequest().begin())->CanGetMoresettings() && (*GetRequest().begin())->GetMoresettings().CanGet()) {
        ITERATE(CMSSearchSettingsSet::Tdata, iSettings, (*GetRequest().begin())->GetMoresettings().Get()) {
            if((*iSettings)->GetDb() != Name) return false;
        }
    }

    return true;
}

void 
COMSSASearch::RenumberOneSearchSettingId(
    CMSSearchSettings& SearchSettings,
    const int Min
    ) 
{
    SearchSettings.SetSettingid() += Min;
}

void 
COMSSASearch::RenumberSearchSettingId(const int Min)
{

     RenumberOneSearchSettingId((*SetRequest().begin())->SetSettings(), Min);

     if((*GetRequest().begin())->CanGetMoresettings() && (*GetRequest().begin())->GetMoresettings().CanGet()) {
         NON_CONST_ITERATE(CMSSearchSettingsSet::Tdata, iSettings, (*SetRequest().begin())->SetMoresettings().Set()) {
             RenumberOneSearchSettingId(**iSettings, Min);
         }
     }

     NON_CONST_ITERATE(CMSResponse::THitsets, iHits, (*SetResponse().begin())->SetHitsets()) {
         (*iHits)->SetSettingid() += Min;
     }
}

void 
COMSSASearch::RenumberSpectrumNumber(const int Min)
{


    NON_CONST_ITERATE(CMSResponse::THitsets, iHits, (*SetResponse().begin())->SetHitsets()) {
         (*iHits)->SetNumber() += Min;
     }

    NON_CONST_ITERATE(CMSSpectrumset::Tdata, iSpectrum, (*SetRequest().begin())->SetSpectra().Set()) {
         (*iSpectrum)->SetNumber() += Min;
     }
}


void 
COMSSASearch::PopulateOidList(void)
{
    ITERATE(CMSBioseqSet::Tdata, iMSBioseq, (*SetResponse().begin())->SetBioseqs().Set()) {
        SetOids().insert((*iMSBioseq)->GetOid());
    }
}


void 
COMSSASearch::AppendBioseq(const int oid, CConstRef <CBioseq> Bioseq)
{
    CRef <CMSBioseq> MSBioseq (new CMSBioseq);
    MSBioseq->SetSeq(*(const_cast <CBioseq *> (Bioseq.GetPointerOrNull())));
    MSBioseq->SetOid() = oid;
    (*SetResponse().begin())->SetBioseqs().Set().push_back(MSBioseq);
}

void 
COMSSASearch::AppendSearch(CRef <COMSSASearch> OldSearch)
{
    int Min, Max, OldMin, OldMax;

    if(GetRequest().size() == 0)
          NCBI_THROW(COMSSAException, eMSParseException, "No Search Requests");
    if(GetResponse().size() == 0)
           NCBI_THROW(COMSSAException, eMSParseException, "No Search Responses");


    // check library
    if(!CheckLibraryNameAndSize((*GetRequest().begin())->GetSettings().GetDb(),
                                (*GetResponse().begin())->GetDbversion()))
        NCBI_THROW(COMSSAException, eMSNoMatchException, "unmatched sequence library");

    // renumber search settings
    FindMinMaxSearchSettingId(Min, Max);
    OldSearch->FindMinMaxSearchSettingId(OldMin, OldMax);
    OldSearch->RenumberSearchSettingId(Max - OldMin + 1);

    // copy over search settings
    CopySettings(OldSearch);
    
    // renumber spectra
    FindMinMaxSpectrumNumber(Min, Max);
    OldSearch->FindMinMaxSpectrumNumber(OldMin, OldMax);
    OldSearch->RenumberSpectrumNumber(Max - OldMin + 1);

    // copy over spectra
    CopySpectra(OldSearch); 

    // copy over hits
    CopyHitsets(OldSearch);

    // look for bioseqs to add
    PopulateOidList();
    OldSearch->PopulateOidList();

    TOid Diff;
    set_difference(OldSearch->GetOids().begin(), OldSearch->GetOids().end(), GetOids().begin(), GetOids().end(),
                   inserter(Diff, Diff.begin()));
    ITERATE(TOid, iDiff, Diff) {
        AppendBioseq(*iDiff, (*OldSearch->GetResponse().begin())->GetBioseqs().GetBioseqByOid(*iDiff));
    }
}


NCBI_XOMSSA_EXPORT CObjectOStream* SetUpOutputFile(CObjectOStream* os, ESerialDataFormat DataFormat)
{
	if(DataFormat == eSerial_Xml && os) {
        // turn on xml schema
        CObjectOStreamXml *xml_out = dynamic_cast <CObjectOStreamXml *> (os);
        xml_out->SetReferenceSchema();
        // turn off names in named integers
        xml_out->SetWriteNamedIntegersByValue(true);
	}
    return os;
}



END_SCOPE(omssa)
END_SCOPE(objects)
END_NCBI_SCOPE
