/*  $Id: ownership.hpp 377251 2012-10-10 15:55:27Z satskyse $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Sergey Satskiy, NCBI
 * Credits: Denis Vakatov, NCBI (API design)
 *
 */


/** @file
 * Ownership enumeration for various objects
**/

#ifndef _xmlwrapp_ownership_hpp_
#define _xmlwrapp_ownership_hpp_


namespace xml {

/// Used to specify if xmlwrapp should grab the ownership of various objects
enum ownership_type {
    type_own,       ///< Grab the ownership, i.e. the object
                    ///< will be freed by xmlwrapp.
    type_not_own    ///< Do not grab the ownership, i.e. the object
                    ///< will not be freed by xmlwrapp.
};

}

#endif

