"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"useTableClientSide",{enumerable:true,get:function(){return useTableClientSide}});const _react=require("react");const _sortSlice=require("./state/sortSlice");const _pageSlice=require("./state/pageSlice");const _selectSlice=require("./state/selectSlice");const _useColumns=require("../hooks/useColumns");const _useFillers=require("../hooks/useFillers");const _useRowFactoryBuilder=require("../hooks/useRowFactoryBuilder");function useTableClientSide(inputData,config,onSelect,onSortingChange,onPagingChange,defaultPaging){var _config_meta;const[data,setData]=(0,_react.useState)(inputData);const{sorting,sortBy,sortFunction}=(0,_sortSlice.useSorting)(config);const{paging,gotoPageIndex,setPageSize,sliceParams}=(0,_pageSlice.usePaging)(data,defaultPaging);const selectionState=(0,_selectSlice.useSelect)();(0,_react.useEffect)(()=>{onPagingChange&&onPagingChange({index:paging.index,size:paging.size})},[paging]);(0,_react.useEffect)(()=>{onSortingChange&&onSortingChange({column:sorting.column,direction:sorting.direction})},[sorting]);(0,_react.useEffect)(()=>{if(!onSelect)return;const selectedData=selectionState.selected.map(id=>data.find(d=>config.rowIdentifierAccessor(d)===id)).filter(x=>x!==undefined);onSelect(selectedData)},[selectionState.selected]);(0,_react.useEffect)(()=>{if(JSON.stringify(data)===JSON.stringify(inputData))return;selectionState.clearSelected();setData(inputData)},[inputData]);const rowsRaw=[...data].sort(sortFunction).slice(...sliceParams);const rowIds=rowsRaw.map(row=>row.id);const rowFactory=(0,_useRowFactoryBuilder.useRowFactoryBuilder)(config,selectionState,rowIds);const rows=rowsRaw.map(rowFactory);const columns=(0,_useColumns.useColumns)(config,{sorting,sortBy,selected:selectionState.selected,selectAll:selectionState.selectAll,rowIds:rowIds});const fillers=(0,_useFillers.useFillers)(config,rows,paging.size);return{head:{columns},body:{rows,fillers,meta:{noDataTextContent:(_config_meta=config.meta)===null||_config_meta===void 0?void 0:_config_meta.noDataTextContent}},paging:{index:paging.index,size:paging.size,totalDisplayableResults:paging.totalDisplayableResults,actions:{gotoPageIndex,setPageSize}},selection:selectionState}}
//# sourceMappingURL=useTableClientSide.js.map