import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
// eslint-disable-next-line import/no-extraneous-dependencies

import { zIndex } from './constants';
export var notDraggingStyle = {
  transform: undefined,
  transition: undefined
};
var baseDraggingStyle = {
  position: 'fixed',
  top: 0,
  left: 0,
  boxSizing: 'border-box',
  transition: 'none',
  zIndex: zIndex.dragging,
  /**
   * This transparency is intended to allow for better visibility of
   * drop indicators.
   */
  opacity: 0.75,
  pointerEvents: 'none'
};

/**
 * Provides the drag preview styles based on the current drag state.
 */
function getDraggingStyle(_ref) {
  var draggableDimensions = _ref.draggableDimensions,
    previewOffset = _ref.previewOffset;
  var rect = draggableDimensions.rect;
  var translateX = rect.left + previewOffset.x;
  var translateY = rect.top + previewOffset.y;
  var isAtOrigin = translateX === 0 && translateY === 0;
  return _objectSpread(_objectSpread({}, baseDraggingStyle), {}, {
    transform: isAtOrigin ? undefined : "translate(".concat(translateX, "px, ").concat(translateY, "px)"),
    width: rect.width,
    height: rect.height
  });
}

/**
 * Returns the styles which should be provided to the draggable via the
 * `draggableProps` API.
 */
export function getDraggableProvidedStyle(_ref2) {
  var draggableDimensions = _ref2.draggableDimensions,
    draggableState = _ref2.draggableState;
  if (draggableState.type !== 'dragging' || !draggableState.previewOffset || !draggableDimensions) {
    return notDraggingStyle;
  }
  return getDraggingStyle({
    draggableDimensions: draggableDimensions,
    previewOffset: draggableState.previewOffset
  });
}