import { useMemo } from 'react';

// eslint-disable-next-line import/no-extraneous-dependencies

/**
 * Private symbol that is intentionally not exported from this file.
 */
const privateKey = Symbol('DraggableData');

/**
 * Data that is attached to drags. The same data is used for the `draggable()`
 * and `dropTargetForElements()` calls related to a `<Draggable>` instance.
 */

/**
 * Checks if the passed data satisfies `DraggableData` using the private symbol.
 */
export function isDraggableData(data) {
  return data[privateKey] === true;
}

/**
 * Adds the private symbol to the passed data.
 *
 * The symbol allows us to quickly check if an object satisfies `DraggableData`.
 */
export function useDraggableData({
  draggableId,
  droppableId,
  getIndex,
  contextId,
  type
}) {
  return useMemo(() => {
    return {
      [privateKey]: true,
      draggableId,
      droppableId,
      getIndex,
      contextId,
      type
    };
  }, [draggableId, droppableId, getIndex, contextId, type]);
}