/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  common.h

  various macros
*/

#ifndef SORTBOX_COMMON_H
#define SORTBOX_COMMON_H

#include <common/common.h>
#include <stdio.h>
#define LPRINTF(Type, ...) do \
                                 {\
                                  if( Libsortbox ## _ ## Type ##  _On)\
                                   {\
				     if(strcmp(#Type,"OUTPUT")==0)\
                                       lprintf(Libsortbox_out,\
                                               "Libsortbox" ,\
                                               Libsortbox_HEADER_ ## Type ## _On,\
                                               Libsortbox_HEADER_ ## Type ## _LIBNAME_On,\
                                               FALSE,\
					       LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                     else\
                                       lprintf(Libsortbox_err,\
                                               "Libsortbox" ,\
                                               Libsortbox_HEADER_ ## Type ## _On,\
                                               Libsortbox_HEADER_ ## Type ## _LIBNAME_On,\
                                               FALSE,\
                                               LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                   };\
                                 } while(0)
  
#define LPRINTFW(Type, ...) do \
                                 {\
                                  if( Libsortbox ## _ ## Type ##  _On)\
                                   {\
				     if(strcmp(#Type,"OUTPUT")==0)\
                                       lprintf(Libsortbox_out,\
                                               "Libsortbox" ,\
                                               Libsortbox_HEADER_ ## Type ## _On,\
                                               Libsortbox_HEADER_ ## Type ## _LIBNAME_On,\
                                               TRUE,\
					       LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                     else\
                                       lprintf(Libsortbox_err,\
                                               "Libsortbox" ,\
                                               Libsortbox_HEADER_ ## Type ## _On,\
                                               Libsortbox_HEADER_ ## Type ## _LIBNAME_On,\
                                               TRUE,\
                                               LIB_ ## Type,\
                                               __FILE__,__LINE__,\
                                               __VA_ARGS__);\
                                   };\
                                 } while(0)

/*
extern FILE *Libsortbox_out;
extern FILE *Libsortbox_err;
extern unsigned int Libsortbox_WARNING_On;
extern unsigned int Libsortbox_ERROR_On;
extern unsigned int Libsortbox_OUTPUT_On;
extern unsigned int Libsortbox_HEADER_On;
*/
#endif


