# Makefile.PL for CBView
#
# cbview --- A viewer for CBR/CBZ comic book archives
# 

use ExtUtils::MakeMaker;
#use threads;

my @deps = (
	['unzip', 	'unzip |head -1 |cut -d \' \' -f 2', 			5.00],
	['zipinfo',	'zipinfo |head -1 |cut -d \' \' -f 2', 			2.00],
	['unrar', 	'unrar |head -2 |tail -1 |cut -d \' \' -f 2',	3.2],
);

for (@deps) {
	my ($app, $test, $target) = @{$_};

	my $value = `$test` or die "Could not find $app!\n";

	die "cbview requires $app $target or greater.\n" 
		unless $value >= $target;
}

WriteMakefile(
	'NAME'			=>	'cbview',
	'VERSION_FROM'	=> 	'cbview',
	'PREREQ_PM'		=>	{ 
		'Gtk2'					=> 1.023,
		'String::ShellQuote' 	=> 0,
		'Getopt::Std'			=> 0,
		},
	'AUTHOR' =>	'Brian McFee (keebler@elvine.org)',
	EXE_FILES		=> ['cbview'],
	'dist'			=> { COMPRESS => 'gzip', SUFFIX => '.gz', },
);
							
