/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class TagHandlerPool {
    private static final int MAX_POOL_SIZE = 5;
    private Tag[] handlers;
    private int current;

    public TagHandlerPool() {
        this(5);
    }

    public TagHandlerPool(int capacity) {
        this.handlers = new Tag[capacity];
        this.current = -1;
    }

    public synchronized Tag get(Class handlerClass) throws JspException {
        Tag handler = null;
        if (this.current < 0) {
            try {
                return (Tag)handlerClass.newInstance();
            }
            catch (Exception e) {
                throw new JspException(e.getMessage(), (Throwable)e);
            }
        }
        handler = this.handlers[this.current--];
        return handler;
    }

    public synchronized void reuse(Tag handler) {
        if (this.current < this.handlers.length - 1) {
            this.handlers[++this.current] = handler;
        } else {
            handler.release();
        }
    }

    public synchronized void release() {
        int i = this.current;
        while (i >= 0) {
            this.handlers[i].release();
            --i;
        }
    }
}

