/*
 * Decompiled with CFR 0.152.
 */
import gsfc.nssdc.cdf.Attribute;
import gsfc.nssdc.cdf.CDFConstants;
import gsfc.nssdc.cdf.Variable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class NewAttributeAction
extends AbstractAction
implements CDFConstants {
    static final long serialVersionUID = 1L;
    private static final String DEFAULT_NAME = "New Attribute";
    private MYEditor myEditor;
    private AttributePanel attrPanel;
    private char gORv;

    public NewAttributeAction(AttributePanel attributePanel, char c) {
        this(attributePanel, "New " + c + "Attribute");
        this.gORv = c;
    }

    public NewAttributeAction(AttributePanel attributePanel, String string) {
        super(string);
        this.attrPanel = attributePanel;
        this.myEditor = attributePanel.getMyEditor();
    }

    @Override
    public void putValue(String string, Object object) {
        if (object != null) {
            super.putValue(string, object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.myEditor.setWaitCursor();
        if (this.myEditor.theCDF == null) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.myEditor.sharedInstance(), "Must open a CDF before creating attributes.", "MYEditor: Error", 0);
        } else {
            Attribute attribute = NewAttributeDialog.createAttribute(this.myEditor.getFrame(), this.myEditor.theCDF, "Create " + this.gORv + "Attribute", this.attrPanel.getScope());
            if (attribute != null) {
                this.attrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                this.attrPanel.updateAttrPanel(attribute, true);
                this.attrPanel.updateListOfAttributes();
                if (this.attrPanel.getScope() == 2L) {
                    this.myEditor.gAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                    this.myEditor.gAttrPanel.getRightPanel().revalidate();
                    this.myEditor.gAttrPanel.getRightPanel().repaint();
                } else {
                    this.myEditor.vAttrPanel.getCDFSpecPanel().set(this.myEditor.theCDF);
                    this.myEditor.vAttrPanel.getRightPanel().revalidate();
                    this.myEditor.vAttrPanel.getRightPanel().repaint();
                }
                if (this.myEditor.variablePanel.getSelectedVar() != null) {
                    Variable variable = this.myEditor.variablePanel.getSelectedVar();
                    this.myEditor.variablePanel.getvVarEntryTableScrollPane().buildTable(variable);
                    this.myEditor.variablePanel.getRightPanel().revalidate();
                }
                this.attrPanel.reselectCurrentAttribute();
            }
        }
        this.myEditor.setDefaultCursor();
    }
}

