/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.proto.plugin.mandelbrot;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import net.gcalc.calc.gui.SwingGUI;
import net.gcalc.calc.gui.gradient.CompoundGradient;
import net.gcalc.calc.gui.gradient.GradientCanvas;
import net.gcalc.plugin.plane.CartesianGraphPlugin;
import net.gcalc.plugin.plane.gui.CoordinatePanel;
import net.gcalc.plugin.properties.GraphProperties;
import net.gcalc.proto.plugin.mandelbrot.MandelbrotGraph;

public class MandelbrotPlugin
extends CartesianGraphPlugin
implements Observer {
    private MandelbrotGraph mgraph = new MandelbrotGraph(this);
    private JProgressBar progressbar;

    public MandelbrotPlugin() {
        this.graph = this.mgraph;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.graph.redrawAll();
        }
    }

    protected void initPropertiesPanel() {
        this.propertiesPanel.addTab("Screen", this.makeGraphDimensionPanel());
        this.propertiesPanel.addTab("Gradient", new GradientChooser(this.mgraph.getGradient()));
    }

    public void init() {
        this.initPropertiesPanel();
        this.initMenuBar();
        CoordinatePanel cp = new CoordinatePanel(2);
        this.graph.setCoordinatePanel(cp);
        Box graphBox = Box.createVerticalBox();
        graphBox.add(this.graph);
        graphBox.add(cp);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.getContentPane().add("Center", graphBox);
        this.progressbar = new JProgressBar(0, this.graph.getHeight() * this.graph.getWidth());
        this.getContentPane().add("South", this.progressbar);
        this.graph.getProperties().addObserver(this);
        this.setTitle(this.getPluginName());
        this.pack();
        this.setInitialized(true);
    }

    public void update(Observable src, Object key) {
        GraphProperties properties = (GraphProperties)src;
        if (key.equals("progress")) {
            this.progressbar.setValue((Integer)properties.get("progress"));
        }
    }

    public String getDescription() {
        return "<p>Show the really cool Mandelbrot Set fractal.</p>";
    }

    public String getPluginName() {
        return "Mandelbrot Set Plugin";
    }

    public void shutdown() {
        this.mgraph.killThread();
        super.shutdown();
    }

    class GradientChooser
    extends JPanel
    implements ActionListener {
        private GradientCanvas gradientCanvas;
        private JButton apply;
        private JButton ok;

        public GradientChooser(CompoundGradient cg) {
            Box vBox = Box.createVerticalBox();
            Box buttonBox = Box.createHorizontalBox();
            buttonBox.add(Box.createHorizontalGlue());
            this.apply = new JButton("Apply");
            buttonBox.add(this.apply);
            this.apply.addActionListener(this);
            this.gradientCanvas = new GradientCanvas(MandelbrotPlugin.this.mgraph.getGradient());
            vBox.add(SwingGUI.wrapTitledBorder(this.gradientCanvas, "Gradient"));
            vBox.add(buttonBox);
            vBox.add(Box.createVerticalGlue());
            this.add(vBox);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.apply) {
                MandelbrotPlugin.this.mgraph.setGradient(this.gradientCanvas.getGradient());
                MandelbrotPlugin.this.mgraph.redrawAll();
                return;
            }
            if (e.getSource() == this.ok) {
                MandelbrotPlugin.this.mgraph.setGradient(this.gradientCanvas.getGradient());
                MandelbrotPlugin.this.mgraph.redrawAll();
            }
            this.setVisible(false);
        }
    }
}

