/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.models;

import net.gcalc.calc.math.functions.Function;

public class Model {
    private Function[] functions;
    private String[] reps;

    protected Model(Function f, String s) {
        this(new Function[]{f}, new String[]{s});
    }

    protected Model(Function f) {
        this(f, f.toInfix());
    }

    protected Model(Function[] f, String[] s) {
        this.functions = new Function[f.length];
        this.reps = new String[s.length];
        System.arraycopy(f, 0, this.functions, 0, this.functions.length);
        System.arraycopy(s, 0, this.reps, 0, this.reps.length);
    }

    public Function getFunction() {
        return this.getFunction(0);
    }

    public Function getFunction(int i) {
        return this.functions[i];
    }

    public int getNumberOfFunctions() {
        return this.functions.length;
    }

    public String[] getStringRepresentation() {
        return this.reps;
    }

    public String toString() {
        if (this.functions == null || this.functions.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (this.reps.length > 1) {
            sb.append("[");
        }
        int i = 0;
        while (i < this.reps.length) {
            sb.append(String.valueOf(i != 0 ? ", " : "") + this.reps[i]);
            ++i;
        }
        if (this.reps.length > 1) {
            sb.append("]");
        }
        return sb.toString();
    }
}

