/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.parser.ParseTree;
import net.gcalc.calc.parser.Token;

public class Variable
extends Function {
    private Token var;

    public Variable(ParseTree pt) {
        super(pt);
        if (!pt.getRoot().isVariable()) {
            throw new IllegalArgumentException(pt.toString());
        }
        this.var = pt.getRoot();
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        if (vt != null && vt.containsVariable(this.var)) {
            return vt.getValue(this.var);
        }
        if (st != null && st.containsVariable(this.var)) {
            return st.getFunction(this.var).evaluate(st, vt);
        }
        return Double.NaN;
    }

    public Function derivative(Vector vars) {
        Function F = NOT_A_NUMBER;
        int i = 0;
        while (i < vars.size()) {
            if (!vars.elementAt(0).equals(this.var)) {
                return ZERO;
            }
            F = ONE;
            ++i;
        }
        return F;
    }
}

