/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl.listing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.command.impl.listing.FileFilter;
import org.apache.ftpserver.command.impl.listing.FileFormater;
import org.apache.ftpserver.command.impl.listing.ListArgument;
import org.apache.ftpserver.command.impl.listing.RegexFileFilter;
import org.apache.ftpserver.command.impl.listing.VisibleFileFilter;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;

public class DirectoryLister {
    private String traverseFiles(List<? extends FtpFile> files, FileFilter filter, FileFormater formater) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.traverseFiles(files, filter, formater, true));
        sb.append(this.traverseFiles(files, filter, formater, false));
        return sb.toString();
    }

    private String traverseFiles(List<? extends FtpFile> files, FileFilter filter, FileFormater formater, boolean matchDirs) {
        StringBuilder sb = new StringBuilder();
        for (FtpFile ftpFile : files) {
            if (ftpFile == null || filter != null && !filter.accept(ftpFile) || ftpFile.isDirectory() != matchDirs) continue;
            sb.append(formater.format(ftpFile));
        }
        return sb.toString();
    }

    public String listFiles(ListArgument argument, FileSystemView fileSystemView, FileFormater formater) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<? extends FtpFile> files = this.listFiles(fileSystemView, argument.getFile());
        if (files != null) {
            FileFilter filter = null;
            if (!argument.hasOption('a')) {
                filter = new VisibleFileFilter();
            }
            if (argument.getPattern() != null) {
                filter = new RegexFileFilter(argument.getPattern(), filter);
            }
            sb.append(this.traverseFiles(files, filter, formater));
        }
        return sb.toString();
    }

    private List<? extends FtpFile> listFiles(FileSystemView fileSystemView, String file) {
        ArrayList<FtpFile> files = null;
        try {
            FtpFile virtualFile = fileSystemView.getFile(file);
            if (virtualFile.isFile()) {
                ArrayList<FtpFile> auxFiles = new ArrayList<FtpFile>();
                auxFiles.add(virtualFile);
                files = auxFiles;
            } else {
                files = virtualFile.listFiles();
            }
        }
        catch (FtpException ftpException) {
            // empty catch block
        }
        return files;
    }
}

