/*
   Copyright(c) 1999,2000,2001,2002,2003 Grahame M. Kelly(grahame@wildpossum.com)
   You may distribute and/or use for any purpose modified or unmodified
   copies of this software if you preserve the copyright notice above.

   THIS SOFTWARE IS PROVIDED AS IS AND COMES WITH NO WARRANTY OF ANY
   KIND, EITHER EXPRESSED OR IMPLIED.  IN NO EVENT WILL THE
   COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES RESULTING FROM THE
   USE OF THIS SOFTWARE.

   You should have received a copy of the GNU General Public License
   along with this package; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   Originally, LinuxSPA (Linux Serial Protocol Analyser) was used to
   reverse engineering the Nikon E950 Digital Camera Protocols so that
   it may be used under Linux OS. From release 07 onwards, LinuxSPA 
   is being pushed to be a protocol analyser using pluggable user
   filters and display modules.

   Revision     Date            Comments
   --------     ----            ---------------------------------------

   07.1         19/07/03        Project Rename to comply with Trademarks
   07           11/04/02        Command Line Switches
   06           02/02/02        Bug Fixes
   05           02/10/99        Modified for User Filter Operation
   ...          ...             ...
   00           26/09/99        Initial

   NOTE:
   My thanks go to Dios del Tiempo <cronos1_mx@yahoo.com> for his
   contribution to std232 with the "-a" additions.

*/


/*--------------------- LinuxSPA - User Filter -----------------*/
/*                                                              */
/* Reads sniffed data packets from the pipe and then formats    */
/* the output from the following:                               */
/*                                                              */
/*    000000 : <  61, 62, 63, 78, 79,       			*/
/*    000000 : >  41, 42, 43, 00,                      		*/
/*    000009 : <  67, 6b, 06,                          	 	*/
/*                                                              */
/* where ^^^ is the number of hex bytes for that direction and  */
/* the '<' is input, '>' is output direction.                   */
/*                                                              */
/* to the following format:                                     */
/*                                                              */
/*     000000 : <  61 (a), 62 (b), 63 (c), 78 (x), 79 (y),      */
/*     000000 : >  41 (A), 42 (A), 43 (C), 00 NUL,              */
/*     000009 : <  67 (g), 6b (k), 06 ACK,                      */
/*                                                              */
/* Bracketted data is the ASCII equivalent or if it is a        */
/* control charcter its nuemonic is shown instead.              */
/*                                                              */
/*								*/
/*  Generally you would use this as follows:			*/
/*								*/
/*	LinuxSPA | std232 > myfile.txt                          */
/*								*/
/*  This will read the sniffed data, filter it, then forward    */
/*  the final data to the user file: myfile.txt for later use   */
/*								*/
/*--------------------------------------------------------------*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define DEBUG 0
#define MAXSIZE 44
#define LINEMAX 80
#define ENTRIES 256 
#define ENTRY_SIZE 4
#define ASCII  "./ascii.flt"
#define FIRST_DATA "000000 :"


char cmatrix [ENTRIES+1][ENTRY_SIZE+1];
char dmatrix [] = "...\0";



char * convert (const char * temp)
{
	unsigned int index;

	(unsigned int) index = strtol(temp, NULL, 16);
	if (index < 256)
	     return (&cmatrix[index][0]);
	else return (&dmatrix[0]);
}



int main (int argc, char * argv[])
{
	char line[LINEMAX], out[LINEMAX], temp[LINEMAX], *result;
	int  x, linesize, headers, ascii_flag;
	FILE *fp;

	/* Check number of arguments */

	if (argc > 2)
	  {
	        fprintf(stderr, "%s: too many arguments\n", argv[0]);
	        fprintf(stderr, "Usage: %s [-a]\n", argv[0]);
		exit(1);
	  }

	/* Check if there is the ASCII argument */

	ascii_flag = 0;
	if (argc == 2)
	  {
	        if (strcmp(argv[1], "-a") == 0)
		  {
		        ascii_flag = 1;
		  }
		else
		  {
	                fprintf(stderr, "%s: incorrect argument\n", argv[0]);
	                fprintf(stderr, "Usage: %s [-a]\n", argv[0]);
		        exit(2);
		  }
	  }

	/* Load the user conversion matrix */
	fp = fopen(ASCII, "r");
	if (fp == NULL) {	
		fprintf(stderr, "Error Opening user conversion file: %s\n",
			ASCII);
		exit(-1);
	}

	/* Read the user conversion matrix from file */
	for (x = 0; x < ENTRIES; x++) {
		if (fgets(&line[0], LINEMAX, fp) == NULL) {
			perror("Bad filter read");
			exit(-1);
		}
		if (strcpy(&cmatrix[x][0], &line[0]) == NULL) {
			perror("Null value error on strcpy 1");
			exit(-1);
		}
		cmatrix[x][ENTRY_SIZE-1] = '\0';
	}	
	
	/* Close the user conversion matrix file now */
	fclose(fp);

	/* Read standard output until NULL */

	for (headers = 1; fgets(line, LINEMAX-1, stdin) != NULL;)
	{
	  /* Check if we are currently reading headers, and if this line
	     is the first data line*/

	  if ((headers == 1) && 
	      (strncmp(line, FIRST_DATA, strlen(FIRST_DATA)) == 0))
	        headers = 0;

	  /* Check if the current line is a header */

	  if (headers == 1)
	  {
	        /* If so, print it without processing */

		fprintf (stdout, "%s", &line[0]);
	  }
	  else
	  {
		/* If not, got a line now, print out line address */
		linesize = strlen(&line[0]);
		strncpy(&out[0], &line[0], 10);
		out[10] = ' '; out[11] = ' '; out[12] = '\0';
		fprintf (stdout, "%s", &out[0]);

		/* Now printout the character conversions */
		if (linesize > 12) {
			for (x = 12; x < linesize-1 && x < MAXSIZE; x++) {
				strncpy(&temp[0], &line[x], 2);
				temp[2] = '\0';

				/* If ASCII argument was issued, don't print
				   hex data */
  
				if (ascii_flag == 0)
				        fprintf(stdout, "%s ", &temp[0]);

				result = convert(&temp[0]);
				fprintf(stdout, "%s, ", result);
				x += 3;		
			}
		}
		fprintf(stdout,"\n");
		fflush (stdout);
	  }
	}
	return (0);
}

/* End of Program */
