/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jrobin.mrtg.client.LinkInfo;
import org.jrobin.mrtg.client.RouterInfo;
import org.jrobin.mrtg.client.Util;

class EditLinkDialog
extends JDialog {
    static final String ADD_TITLE = "New interface";
    static final String EDIT_TITLE = "Edit interface data";
    static final String DEFAULT_SAMPLING_INTERVAL = "300";
    static final int MAX_SAMPLING_INTERVAL = 600;
    static final int MIN_SAMPLING_INTERVAL = 10;
    private LinkInfo[] linkInfo;
    private String[] ifDescrs;
    private RouterInfo routerInfo;
    boolean insertMode = false;
    private JLabel routerLabel = Util.standardLabel("Router: ");
    private JLabel linksListLabel = Util.standardLabel("Interface: ");
    private JLabel descrLabel = Util.standardLabel("Description: ");
    private JLabel samplingLabel = Util.standardLabel("Sampling interval: ");
    private JLabel activeLabel = Util.standardLabel("Active: ");
    private JLabel routerValueLabel = new JLabel();
    private JList linksList = new JList();
    private JTextField descrField = Util.standardTextField();
    private JTextField samplingField = Util.standardTextField();
    private JCheckBox activeBox = new JCheckBox("", true);
    private JButton okButton = Util.standardButton("OK");
    private JButton cancelButton = Util.standardButton("Cancel");

    EditLinkDialog(Frame frame, RouterInfo routerInfo, String[] stringArray) {
        super(frame, ADD_TITLE, true);
        this.insertMode = true;
        this.routerInfo = routerInfo;
        this.ifDescrs = stringArray;
        this.constructUserInterface();
        this.pack();
        this.setVisible(true);
    }

    EditLinkDialog(Frame frame, RouterInfo routerInfo, LinkInfo linkInfo) {
        super(frame, EDIT_TITLE, true);
        this.insertMode = false;
        this.routerInfo = routerInfo;
        this.linkInfo = new LinkInfo[]{linkInfo};
        this.constructUserInterface();
        this.pack();
        this.setVisible(true);
    }

    private void constructUserInterface() {
        JPanel jPanel = (JPanel)this.getContentPane();
        Box box = Box.createVerticalBox();
        box.add(Util.getPanelFor(this.routerLabel, this.routerValueLabel));
        box.add(Util.getPanelFor(this.linksListLabel, Util.standardScrollPane(this.linksList)));
        box.add(Util.getPanelFor(this.descrLabel, this.descrField));
        box.add(Util.getPanelFor(this.samplingLabel, this.samplingField));
        box.add(Util.getPanelFor(this.activeLabel, this.activeBox));
        box.add(Util.getPanelFor(Util.standardLabel(""), this.okButton, this.cancelButton));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditLinkDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditLinkDialog.this.cancel();
            }
        });
        jPanel.add(box);
        this.setDefaultCloseOperation(2);
        this.routerValueLabel.setText(this.routerInfo.getHost());
        if (this.insertMode) {
            this.linksList.setModel(new DefaultComboBoxModel<String>(this.ifDescrs));
            this.linksList.setSelectedIndex(0);
            this.samplingField.setText(DEFAULT_SAMPLING_INTERVAL);
            this.activeBox.setSelected(true);
        } else {
            this.linksList.setModel(new DefaultComboBoxModel<String>(this.routerInfo.getInterfaces()));
            this.linksList.setSelectedValue(this.linkInfo[0].getIfDescr(), true);
            this.linksList.setEnabled(false);
            this.descrField.setText(this.linkInfo[0].getDescr());
            this.samplingField.setText("" + this.linkInfo[0].getSamplingInterval());
            this.activeBox.setSelected(this.linkInfo[0].isActive());
        }
        this.okButton.setMnemonic(79);
        this.cancelButton.setMnemonic(67);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setDefaultCloseOperation(2);
        Util.centerOnScreen(this);
    }

    private void close() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void ok() {
        int n;
        try {
            n = Integer.parseInt(this.samplingField.getText());
            if (n < 10 || n > 600) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            Util.error(this, "Sampling interval must be a number between 10 and 600");
            return;
        }
        if (this.insertMode) {
            Object[] objectArray = this.linksList.getSelectedValues();
            int n2 = objectArray.length;
            if (n2 == 0) {
                Util.error(this, "Select at least one interface to add");
                return;
            }
            this.linkInfo = new LinkInfo[n2];
            for (int i = 0; i < n2; ++i) {
                this.linkInfo[i] = new LinkInfo();
                this.linkInfo[i].setIfDescr((String)objectArray[i]);
                this.linkInfo[i].setActive(this.activeBox.isSelected());
                this.linkInfo[i].setDescr(this.descrField.getText());
                this.linkInfo[i].setSamplingInterval(n);
            }
        } else {
            this.linkInfo[0].setActive(this.activeBox.isSelected());
            this.linkInfo[0].setDescr(this.descrField.getText());
            this.linkInfo[0].setSamplingInterval(n);
        }
        this.close();
    }

    private void cancel() {
        this.linkInfo = null;
        this.close();
    }

    LinkInfo[] getLinkInfo() {
        return this.linkInfo;
    }
}

