/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.protocol;

import java.util.Map;
import org.apache.maven.wagon.providers.http.httpclient.annotation.ThreadSafe;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpRequestHandler;
import org.apache.maven.wagon.providers.http.httpclient.protocol.HttpRequestHandlerResolver;
import org.apache.maven.wagon.providers.http.httpclient.protocol.UriPatternMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class HttpRequestHandlerRegistry
implements HttpRequestHandlerResolver {
    private final UriPatternMatcher<HttpRequestHandler> matcher = new UriPatternMatcher();

    public void register(String pattern, HttpRequestHandler handler) {
        if (pattern == null) {
            throw new IllegalArgumentException("URI request pattern may not be null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Request handler may not be null");
        }
        this.matcher.register(pattern, handler);
    }

    public void unregister(String pattern) {
        this.matcher.unregister(pattern);
    }

    public void setHandlers(Map<String, HttpRequestHandler> map) {
        this.matcher.setObjects(map);
    }

    public Map<String, HttpRequestHandler> getHandlers() {
        return this.matcher.getObjects();
    }

    @Override
    public HttpRequestHandler lookup(String requestURI) {
        return this.matcher.lookup(requestURI);
    }
}

