# Upgrading to 10.0.0

## Removal of some required libraries

Cucumber has a lot of interconnected pieces. Internally we often refer to these as the polyglot libraries
(Such as cucumber-gherkin, cucumber-tag-expressions e.t.c.), and often these can be upgraded quite aggressively
in one flavour of cucumber that then causes issues with maintenance for the other flavours

As such one new technical piece will see that the majority of the version restrictions for these libraries will
now be moved out into `cucumber-core` - This will mean that when packages are updated we need to make the requisite
changes in fewer locations

NB: To start with we are only removing the `cucumber-gherkin` and `cucumber-messages` libraries from this gem
but will slowly make this change more aggressively across the coming releases 

## Internal technical rewrites

Lots of the internal workings of cucumber have been refactored to use newer ruby syntaxes e.t.c.

Because many of these files have been untouched in years it could be that there is some unexpected side-effects
but it is expected that given the changes were all made to deeply internal files, there shouldn't be any
issues

## CCK conformance

We are now back up to speed with full CCK conformance (v18), which includes emitting the `testRunStartedId` consistently
across an entire test run. This will make any reporters work consistently as well as ensuring the core flavours of
cucumber are now back fully aligned

## Deprecated Assistance / Cleanup helper methods

### #text?

The `#text?` method for checking differences in multi-line heredocs or texts has been slated for removal

Should you wish to check multi-line text fragments for differences and issues, there are a host of better-suited
libraries that handle this better, and this should be handled outside the remit of cucumber

### Cucumber.use_legacy_autoloader configuration setting

This was intended as a stop-gap after version3->4 had a lot of new architectural changes

It was only ever meant to live in cucumber for a short while, but given we never got around to removing it, now
is as good a time as any to deprecate it (It will be deleted and won't return from v11)

### StepDefinitionLight

This class and its associated actions is now considered deprecated. It serves little to no purpose other than in
one of the legacy formatters that we aim to remove and port to messages and some associated "shim" languages
which aren't in the purview of the team anymore

## Removed Assistance / Cleanup helper methods

### CCK

The CCK previously used to duplicate some assets during testing - This is now removed and the assets that are used
are now purely from the CCK proper. This is the final step in full conformance for the CCK

### Tag Expressions Sanitization helpers

This is again another item that should have been removed a long time ago, there were both some internal `aruba` helpers
and some external facing helpers that attempted to fix poor tag expression syntax. These are now all removed

In all situations anything that is not a valid tag expression will simply crash and the user will need to fix
up their code to be syntactically valid

### StepDefinitionLight associated helpers

The associated helpers or secondary usages from this "now deprecated" class are now removed

Nothing related to this should be used going forwards - the entire area of the codebase supporting this will
be completely deleted in v11

### Webrick alias handlers

There is a lot of legacy code regarding some tests that needed webrick handlers. Many of these tests have been
modified, and we are going to slowly phase out the tests that "check" or "validate" other frameworks

The reason for the above is this is an inverse relationship. Said frameworks should be using cucumber to validate
their usage, not the other way around - as if we found an issue, we would do nothing more than bubble it up to
the relevant repository
