// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/tpu/v2/cloud_tpu.proto

#include "google/cloud/tpu/v2/internal/tpu_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace tpu_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

TpuTracingConnection::TpuTracingConnection(
    std::shared_ptr<tpu_v2::TpuConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::tpu::v2::Node> TpuTracingConnection::ListNodes(
    google::cloud::tpu::v2::ListNodesRequest request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::ListNodes");
  internal::OTelScope scope(span);
  auto sr = child_->ListNodes(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::tpu::v2::Node>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::tpu::v2::Node> TpuTracingConnection::GetNode(
    google::cloud::tpu::v2::GetNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::GetNode");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetNode(request));
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuTracingConnection::CreateNode(
    google::cloud::tpu::v2::CreateNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::CreateNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateNode(request));
}

future<StatusOr<google::cloud::tpu::v2::OperationMetadata>>
TpuTracingConnection::DeleteNode(
    google::cloud::tpu::v2::DeleteNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::DeleteNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteNode(request));
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuTracingConnection::StopNode(
    google::cloud::tpu::v2::StopNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::StopNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StopNode(request));
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuTracingConnection::StartNode(
    google::cloud::tpu::v2::StartNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::StartNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->StartNode(request));
}

future<StatusOr<google::cloud::tpu::v2::Node>> TpuTracingConnection::UpdateNode(
    google::cloud::tpu::v2::UpdateNodeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::UpdateNode");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateNode(request));
}

StatusOr<google::cloud::tpu::v2::GenerateServiceIdentityResponse>
TpuTracingConnection::GenerateServiceIdentity(
    google::cloud::tpu::v2::GenerateServiceIdentityRequest const& request) {
  auto span =
      internal::MakeSpan("tpu_v2::TpuConnection::GenerateServiceIdentity");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateServiceIdentity(request));
}

StreamRange<google::cloud::tpu::v2::AcceleratorType>
TpuTracingConnection::ListAcceleratorTypes(
    google::cloud::tpu::v2::ListAcceleratorTypesRequest request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::ListAcceleratorTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListAcceleratorTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::tpu::v2::AcceleratorType>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::tpu::v2::AcceleratorType>
TpuTracingConnection::GetAcceleratorType(
    google::cloud::tpu::v2::GetAcceleratorTypeRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::GetAcceleratorType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAcceleratorType(request));
}

StreamRange<google::cloud::tpu::v2::RuntimeVersion>
TpuTracingConnection::ListRuntimeVersions(
    google::cloud::tpu::v2::ListRuntimeVersionsRequest request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::ListRuntimeVersions");
  internal::OTelScope scope(span);
  auto sr = child_->ListRuntimeVersions(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::tpu::v2::RuntimeVersion>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::tpu::v2::RuntimeVersion>
TpuTracingConnection::GetRuntimeVersion(
    google::cloud::tpu::v2::GetRuntimeVersionRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::GetRuntimeVersion");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetRuntimeVersion(request));
}

StatusOr<google::cloud::tpu::v2::GetGuestAttributesResponse>
TpuTracingConnection::GetGuestAttributes(
    google::cloud::tpu::v2::GetGuestAttributesRequest const& request) {
  auto span = internal::MakeSpan("tpu_v2::TpuConnection::GetGuestAttributes");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetGuestAttributes(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<tpu_v2::TpuConnection> MakeTpuTracingConnection(
    std::shared_ptr<tpu_v2::TpuConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<TpuTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace tpu_v2_internal
}  // namespace cloud
}  // namespace google
