// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/servicedirectory/v1/lookup_service.proto

#include "google/cloud/servicedirectory/v1/internal/lookup_connection_impl.h"
#include "google/cloud/servicedirectory/v1/internal/lookup_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace servicedirectory_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<servicedirectory_v1::LookupServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<servicedirectory_v1::LookupServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<servicedirectory_v1::LookupServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<servicedirectory_v1::LookupServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<
          servicedirectory_v1::LookupServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

LookupServiceConnectionImpl::LookupServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<servicedirectory_v1_internal::LookupServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      LookupServiceConnection::options())) {}

StatusOr<google::cloud::servicedirectory::v1::ResolveServiceResponse>
LookupServiceConnectionImpl::ResolveService(
    google::cloud::servicedirectory::v1::ResolveServiceRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ResolveService(request),
      [this](grpc::ClientContext& context,
             google::cloud::servicedirectory::v1::ResolveServiceRequest const&
                 request) { return stub_->ResolveService(context, request); },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace servicedirectory_v1_internal
}  // namespace cloud
}  // namespace google
