// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_keys.proto

#include "google/cloud/resourcemanager/v3/tag_keys_connection.h"
#include "google/cloud/resourcemanager/v3/internal/tag_keys_connection_impl.h"
#include "google/cloud/resourcemanager/v3/internal/tag_keys_option_defaults.h"
#include "google/cloud/resourcemanager/v3/internal/tag_keys_stub_factory.h"
#include "google/cloud/resourcemanager/v3/internal/tag_keys_tracing_connection.h"
#include "google/cloud/resourcemanager/v3/tag_keys_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TagKeysConnection::~TagKeysConnection() = default;

StreamRange<google::cloud::resourcemanager::v3::TagKey>
TagKeysConnection::ListTagKeys(
    google::cloud::resourcemanager::v3::
        ListTagKeysRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::TagKey>>();
}

StatusOr<google::cloud::resourcemanager::v3::TagKey>
TagKeysConnection::GetTagKey(
    google::cloud::resourcemanager::v3::GetTagKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::resourcemanager::v3::TagKey>
TagKeysConnection::GetNamespacedTagKey(
    google::cloud::resourcemanager::v3::GetNamespacedTagKeyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::resourcemanager::v3::TagKey>>
TagKeysConnection::CreateTagKey(
    google::cloud::resourcemanager::v3::CreateTagKeyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagKey>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagKey>>
TagKeysConnection::UpdateTagKey(
    google::cloud::resourcemanager::v3::UpdateTagKeyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagKey>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::TagKey>>
TagKeysConnection::DeleteTagKey(
    google::cloud::resourcemanager::v3::DeleteTagKeyRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagKey>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::iam::v1::Policy> TagKeysConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> TagKeysConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
TagKeysConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<TagKeysConnection> MakeTagKeysConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 TagKeysPolicyOptionList>(options, __func__);
  options =
      resourcemanager_v3_internal::TagKeysDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = resourcemanager_v3_internal::CreateDefaultTagKeysStub(
      background->cq(), options);
  return resourcemanager_v3_internal::MakeTagKeysTracingConnection(
      std::make_shared<resourcemanager_v3_internal::TagKeysConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
