// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recommender/v1/recommender_service.proto

#include "google/cloud/recommender/v1/internal/recommender_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace recommender_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RecommenderTracingStub::RecommenderTracingStub(
    std::shared_ptr<RecommenderStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::recommender::v1::ListInsightsResponse>
RecommenderTracingStub::ListInsights(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::ListInsightsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "ListInsights");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListInsights(context, request));
}

StatusOr<google::cloud::recommender::v1::Insight>
RecommenderTracingStub::GetInsight(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetInsightRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "GetInsight");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetInsight(context, request));
}

StatusOr<google::cloud::recommender::v1::Insight>
RecommenderTracingStub::MarkInsightAccepted(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkInsightAcceptedRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "MarkInsightAccepted");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->MarkInsightAccepted(context, request));
}

StatusOr<google::cloud::recommender::v1::ListRecommendationsResponse>
RecommenderTracingStub::ListRecommendations(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::ListRecommendationsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "ListRecommendations");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRecommendations(context, request));
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderTracingStub::GetRecommendation(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetRecommendationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "GetRecommendation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRecommendation(context, request));
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderTracingStub::MarkRecommendationDismissed(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationDismissedRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "MarkRecommendationDismissed");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->MarkRecommendationDismissed(context, request));
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderTracingStub::MarkRecommendationClaimed(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationClaimedRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "MarkRecommendationClaimed");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->MarkRecommendationClaimed(context, request));
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderTracingStub::MarkRecommendationSucceeded(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationSucceededRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "MarkRecommendationSucceeded");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->MarkRecommendationSucceeded(context, request));
}

StatusOr<google::cloud::recommender::v1::Recommendation>
RecommenderTracingStub::MarkRecommendationFailed(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::MarkRecommendationFailedRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "MarkRecommendationFailed");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->MarkRecommendationFailed(context, request));
}

StatusOr<google::cloud::recommender::v1::RecommenderConfig>
RecommenderTracingStub::GetRecommenderConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetRecommenderConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "GetRecommenderConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRecommenderConfig(context, request));
}

StatusOr<google::cloud::recommender::v1::RecommenderConfig>
RecommenderTracingStub::UpdateRecommenderConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::UpdateRecommenderConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "UpdateRecommenderConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateRecommenderConfig(context, request));
}

StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
RecommenderTracingStub::GetInsightTypeConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::GetInsightTypeConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "GetInsightTypeConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetInsightTypeConfig(context, request));
}

StatusOr<google::cloud::recommender::v1::InsightTypeConfig>
RecommenderTracingStub::UpdateInsightTypeConfig(
    grpc::ClientContext& context,
    google::cloud::recommender::v1::UpdateInsightTypeConfigRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.recommender.v1.Recommender",
                                     "UpdateInsightTypeConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateInsightTypeConfig(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<RecommenderStub> MakeRecommenderTracingStub(
    std::shared_ptr<RecommenderStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<RecommenderTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recommender_v1_internal
}  // namespace cloud
}  // namespace google
