// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/optimization/v1/fleet_routing.proto

#include "google/cloud/optimization/v1/fleet_routing_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace optimization_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FleetRoutingClient::FleetRoutingClient(
    std::shared_ptr<FleetRoutingConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
FleetRoutingClient::~FleetRoutingClient() = default;

StatusOr<google::cloud::optimization::v1::OptimizeToursResponse>
FleetRoutingClient::OptimizeTours(
    google::cloud::optimization::v1::OptimizeToursRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->OptimizeTours(request);
}

future<StatusOr<google::cloud::optimization::v1::BatchOptimizeToursResponse>>
FleetRoutingClient::BatchOptimizeTours(
    google::cloud::optimization::v1::BatchOptimizeToursRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchOptimizeTours(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace optimization_v1
}  // namespace cloud
}  // namespace google
