// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/kms/inventory/v1/key_dashboard_service.proto

#include "google/cloud/kms/inventory/v1/key_dashboard_connection.h"
#include "google/cloud/kms/inventory/v1/internal/key_dashboard_connection_impl.h"
#include "google/cloud/kms/inventory/v1/internal/key_dashboard_option_defaults.h"
#include "google/cloud/kms/inventory/v1/internal/key_dashboard_stub_factory.h"
#include "google/cloud/kms/inventory/v1/internal/key_dashboard_tracing_connection.h"
#include "google/cloud/kms/inventory/v1/key_dashboard_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace kms_inventory_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

KeyDashboardServiceConnection::~KeyDashboardServiceConnection() = default;

StreamRange<google::cloud::kms::v1::CryptoKey>
KeyDashboardServiceConnection::ListCryptoKeys(
    google::cloud::kms::inventory::v1::
        ListCryptoKeysRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::kms::v1::CryptoKey>>();
}

std::shared_ptr<KeyDashboardServiceConnection>
MakeKeyDashboardServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 KeyDashboardServicePolicyOptionList>(options,
                                                                      __func__);
  options = kms_inventory_v1_internal::KeyDashboardServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = kms_inventory_v1_internal::CreateDefaultKeyDashboardServiceStub(
      background->cq(), options);
  return kms_inventory_v1_internal::MakeKeyDashboardServiceTracingConnection(
      std::make_shared<
          kms_inventory_v1_internal::KeyDashboardServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace kms_inventory_v1
}  // namespace cloud
}  // namespace google
