// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/version.proto

#include "google/cloud/dialogflow_es/internal/versions_connection_impl.h"
#include "google/cloud/dialogflow_es/internal/versions_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dialogflow_es::VersionsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dialogflow_es::VersionsRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dialogflow_es::VersionsBackoffPolicyOption>()->clone();
}

std::unique_ptr<dialogflow_es::VersionsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dialogflow_es::VersionsConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

VersionsConnectionImpl::VersionsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dialogflow_es_internal::VersionsStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      VersionsConnection::options())) {}

StreamRange<google::cloud::dialogflow::v2::Version>
VersionsConnectionImpl::ListVersions(
    google::cloud::dialogflow::v2::ListVersionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListVersions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dialogflow::v2::Version>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dialogflow_es::VersionsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dialogflow::v2::ListVersionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dialogflow::v2::ListVersionsRequest const&
                       request) {
              return stub->ListVersions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dialogflow::v2::ListVersionsResponse r) {
        std::vector<google::cloud::dialogflow::v2::Version> result(
            r.versions().size());
        auto& messages = *r.mutable_versions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dialogflow::v2::Version>
VersionsConnectionImpl::GetVersion(
    google::cloud::dialogflow::v2::GetVersionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetVersion(request),
      [this](grpc::ClientContext& context,
             google::cloud::dialogflow::v2::GetVersionRequest const& request) {
        return stub_->GetVersion(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::dialogflow::v2::Version>
VersionsConnectionImpl::CreateVersion(
    google::cloud::dialogflow::v2::CreateVersionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateVersion(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::dialogflow::v2::CreateVersionRequest const& request) {
        return stub_->CreateVersion(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::dialogflow::v2::Version>
VersionsConnectionImpl::UpdateVersion(
    google::cloud::dialogflow::v2::UpdateVersionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateVersion(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::dialogflow::v2::UpdateVersionRequest const& request) {
        return stub_->UpdateVersion(context, request);
      },
      request, __func__);
}

Status VersionsConnectionImpl::DeleteVersion(
    google::cloud::dialogflow::v2::DeleteVersionRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteVersion(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::dialogflow::v2::DeleteVersionRequest const& request) {
        return stub_->DeleteVersion(context, request);
      },
      request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
