// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/ruleset_service.proto

#include "google/cloud/contentwarehouse/v1/rule_set_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace contentwarehouse_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RuleSetServiceClient::RuleSetServiceClient(
    std::shared_ptr<RuleSetServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RuleSetServiceClient::~RuleSetServiceClient() = default;

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::CreateRuleSet(
    std::string const& parent,
    google::cloud::contentwarehouse::v1::RuleSet const& rule_set,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::CreateRuleSetRequest request;
  request.set_parent(parent);
  *request.mutable_rule_set() = rule_set;
  return connection_->CreateRuleSet(request);
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::CreateRuleSet(
    google::cloud::contentwarehouse::v1::CreateRuleSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateRuleSet(request);
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::GetRuleSet(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::GetRuleSetRequest request;
  request.set_name(name);
  return connection_->GetRuleSet(request);
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::GetRuleSet(
    google::cloud::contentwarehouse::v1::GetRuleSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetRuleSet(request);
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::UpdateRuleSet(
    std::string const& name,
    google::cloud::contentwarehouse::v1::RuleSet const& rule_set,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::UpdateRuleSetRequest request;
  request.set_name(name);
  *request.mutable_rule_set() = rule_set;
  return connection_->UpdateRuleSet(request);
}

StatusOr<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::UpdateRuleSet(
    google::cloud::contentwarehouse::v1::UpdateRuleSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateRuleSet(request);
}

Status RuleSetServiceClient::DeleteRuleSet(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::DeleteRuleSetRequest request;
  request.set_name(name);
  return connection_->DeleteRuleSet(request);
}

Status RuleSetServiceClient::DeleteRuleSet(
    google::cloud::contentwarehouse::v1::DeleteRuleSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteRuleSet(request);
}

StreamRange<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::ListRuleSets(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::contentwarehouse::v1::ListRuleSetsRequest request;
  request.set_parent(parent);
  return connection_->ListRuleSets(request);
}

StreamRange<google::cloud::contentwarehouse::v1::RuleSet>
RuleSetServiceClient::ListRuleSets(
    google::cloud::contentwarehouse::v1::ListRuleSetsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRuleSets(std::move(request));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1
}  // namespace cloud
}  // namespace google
