// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/machine_images/v1/machine_images.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_INTERNAL_MACHINE_IMAGES_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_INTERNAL_MACHINE_IMAGES_TRACING_CONNECTION_H

#include "google/cloud/compute/machine_images/v1/machine_images_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_machine_images_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class MachineImagesTracingConnection
    : public compute_machine_images_v1::MachineImagesConnection {
 public:
  ~MachineImagesTracingConnection() override = default;

  explicit MachineImagesTracingConnection(
      std::shared_ptr<compute_machine_images_v1::MachineImagesConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteMachineImage(google::cloud::cpp::compute::machine_images::v1::
                         DeleteMachineImageRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::MachineImage> GetMachineImage(
      google::cloud::cpp::compute::machine_images::v1::
          GetMachineImageRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> GetIamPolicy(
      google::cloud::cpp::compute::machine_images::v1::
          GetIamPolicyRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertMachineImage(google::cloud::cpp::compute::machine_images::v1::
                         InsertMachineImageRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::MachineImage> ListMachineImages(
      google::cloud::cpp::compute::machine_images::v1::ListMachineImagesRequest
          request) override;

  StatusOr<google::cloud::cpp::compute::v1::Policy> SetIamPolicy(
      google::cloud::cpp::compute::machine_images::v1::
          SetIamPolicyRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
  TestIamPermissions(google::cloud::cpp::compute::machine_images::v1::
                         TestIamPermissionsRequest const& request) override;

 private:
  std::shared_ptr<compute_machine_images_v1::MachineImagesConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_machine_images_v1::MachineImagesConnection>
MakeMachineImagesTracingConnection(
    std::shared_ptr<compute_machine_images_v1::MachineImagesConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_machine_images_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_MACHINE_IMAGES_V1_INTERNAL_MACHINE_IMAGES_TRACING_CONNECTION_H
