// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/global_public_delegated_prefixes/v1/global_public_delegated_prefixes.proto

#include "google/cloud/compute/global_public_delegated_prefixes/v1/internal/global_public_delegated_prefixes_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_global_public_delegated_prefixes_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GlobalPublicDelegatedPrefixesTracingConnection::
    GlobalPublicDelegatedPrefixesTracingConnection(
        std::shared_ptr<compute_global_public_delegated_prefixes_v1::
                            GlobalPublicDelegatedPrefixesConnection>
            child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesTracingConnection::DeletePublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        DeletePublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_global_public_delegated_prefixes_v1::"
      "GlobalPublicDelegatedPrefixesConnection::DeletePublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeletePublicDelegatedPrefix(request));
}

StatusOr<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
GlobalPublicDelegatedPrefixesTracingConnection::GetPublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        GetPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_global_public_delegated_prefixes_v1::"
      "GlobalPublicDelegatedPrefixesConnection::GetPublicDelegatedPrefix");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetPublicDelegatedPrefix(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesTracingConnection::InsertPublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        InsertPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_global_public_delegated_prefixes_v1::"
      "GlobalPublicDelegatedPrefixesConnection::InsertPublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->InsertPublicDelegatedPrefix(request));
}

StreamRange<google::cloud::cpp::compute::v1::PublicDelegatedPrefix>
GlobalPublicDelegatedPrefixesTracingConnection::
    ListGlobalPublicDelegatedPrefixes(
        google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
            ListGlobalPublicDelegatedPrefixesRequest request) {
  auto span = internal::MakeSpan(
      "compute_global_public_delegated_prefixes_v1::"
      "GlobalPublicDelegatedPrefixesConnection::"
      "ListGlobalPublicDelegatedPrefixes");
  internal::OTelScope scope(span);
  auto sr = child_->ListGlobalPublicDelegatedPrefixes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::PublicDelegatedPrefix>(std::move(span),
                                                              std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalPublicDelegatedPrefixesTracingConnection::PatchPublicDelegatedPrefix(
    google::cloud::cpp::compute::global_public_delegated_prefixes::v1::
        PatchPublicDelegatedPrefixRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_global_public_delegated_prefixes_v1::"
      "GlobalPublicDelegatedPrefixesConnection::PatchPublicDelegatedPrefix");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->PatchPublicDelegatedPrefix(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_global_public_delegated_prefixes_v1::
                    GlobalPublicDelegatedPrefixesConnection>
MakeGlobalPublicDelegatedPrefixesTracingConnection(
    std::shared_ptr<compute_global_public_delegated_prefixes_v1::
                        GlobalPublicDelegatedPrefixesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<GlobalPublicDelegatedPrefixesTracingConnection>(
        std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_global_public_delegated_prefixes_v1_internal
}  // namespace cloud
}  // namespace google
