(ert-deftest elpy-multiedit--overlay-changed-should-change-text ()
  (elpy-testcase ((:teardown (elpy-multiedit-stop)))
    (insert "foo\n\nfoo\n")
    (goto-char (point-min))
    (elpy-multiedit-add-overlay (point) (line-end-position))
    (forward-line 2)
    (elpy-multiedit-add-overlay (point) (line-end-position))
    (goto-char (point-min))
    (goto-char (line-end-position))
    (let ((inhibit-modification-hooks t))
      (insert "bar"))
    (should (equal (buffer-string)
                   "foobar\n\nfoo\n"))
    (elpy-multiedit--overlay-changed
     (car (overlays-in (line-beginning-position)
                       (line-end-position)))
     t
     (point)
     (point))
    (should (equal (buffer-string)
                   "foobar\n\nfoobar\n"))))
