// Autogenerated from https://www.unicode.org/Public/15.0.0/ucd/

pub fn isPrepend(cp: u21) bool {
    if (cp < 0x600 or cp > 0x11f02) return false;

    return switch (cp) {
        0x600...0x605 => true,
        0x6dd => true,
        0x70f => true,
        0x890...0x891 => true,
        0x8e2 => true,
        0xd4e => true,
        0x110bd => true,
        0x110cd => true,
        0x111c2...0x111c3 => true,
        0x1193f => true,
        0x11941 => true,
        0x11a3a => true,
        0x11a84...0x11a89 => true,
        0x11d46 => true,
        0x11f02 => true,
        else => false,
    };
}

pub fn isCr(cp: u21) bool {
    return cp == 0xd;
}

pub fn isLf(cp: u21) bool {
    return cp == 0xa;
}

pub fn isControl(cp: u21) bool {
    if (cp > 0xe0fff) return false;

    return switch (cp) {
        0x0...0x9 => true,
        0xb...0xc => true,
        0xe...0x1f => true,
        0x7f...0x9f => true,
        0xad => true,
        0x61c => true,
        0x180e => true,
        0x200b => true,
        0x200e...0x200f => true,
        0x2028 => true,
        0x2029 => true,
        0x202a...0x202e => true,
        0x2060...0x2064 => true,
        0x2065 => true,
        0x2066...0x206f => true,
        0xfeff => true,
        0xfff0...0xfff8 => true,
        0xfff9...0xfffb => true,
        0x13430...0x1343f => true,
        0x1bca0...0x1bca3 => true,
        0x1d173...0x1d17a => true,
        0xe0000 => true,
        0xe0001 => true,
        0xe0002...0xe001f => true,
        0xe0080...0xe00ff => true,
        0xe01f0...0xe0fff => true,
        else => false,
    };
}

pub fn isExtend(cp: u21) bool {
    if (cp < 0x300 or cp > 0xe01ef) return false;

    return switch (cp) {
        0x300...0x36f => true,
        0x483...0x487 => true,
        0x488...0x489 => true,
        0x591...0x5bd => true,
        0x5bf => true,
        0x5c1...0x5c2 => true,
        0x5c4...0x5c5 => true,
        0x5c7 => true,
        0x610...0x61a => true,
        0x64b...0x65f => true,
        0x670 => true,
        0x6d6...0x6dc => true,
        0x6df...0x6e4 => true,
        0x6e7...0x6e8 => true,
        0x6ea...0x6ed => true,
        0x711 => true,
        0x730...0x74a => true,
        0x7a6...0x7b0 => true,
        0x7eb...0x7f3 => true,
        0x7fd => true,
        0x816...0x819 => true,
        0x81b...0x823 => true,
        0x825...0x827 => true,
        0x829...0x82d => true,
        0x859...0x85b => true,
        0x898...0x89f => true,
        0x8ca...0x8e1 => true,
        0x8e3...0x902 => true,
        0x93a => true,
        0x93c => true,
        0x941...0x948 => true,
        0x94d => true,
        0x951...0x957 => true,
        0x962...0x963 => true,
        0x981 => true,
        0x9bc => true,
        0x9be => true,
        0x9c1...0x9c4 => true,
        0x9cd => true,
        0x9d7 => true,
        0x9e2...0x9e3 => true,
        0x9fe => true,
        0xa01...0xa02 => true,
        0xa3c => true,
        0xa41...0xa42 => true,
        0xa47...0xa48 => true,
        0xa4b...0xa4d => true,
        0xa51 => true,
        0xa70...0xa71 => true,
        0xa75 => true,
        0xa81...0xa82 => true,
        0xabc => true,
        0xac1...0xac5 => true,
        0xac7...0xac8 => true,
        0xacd => true,
        0xae2...0xae3 => true,
        0xafa...0xaff => true,
        0xb01 => true,
        0xb3c => true,
        0xb3e => true,
        0xb3f => true,
        0xb41...0xb44 => true,
        0xb4d => true,
        0xb55...0xb56 => true,
        0xb57 => true,
        0xb62...0xb63 => true,
        0xb82 => true,
        0xbbe => true,
        0xbc0 => true,
        0xbcd => true,
        0xbd7 => true,
        0xc00 => true,
        0xc04 => true,
        0xc3c => true,
        0xc3e...0xc40 => true,
        0xc46...0xc48 => true,
        0xc4a...0xc4d => true,
        0xc55...0xc56 => true,
        0xc62...0xc63 => true,
        0xc81 => true,
        0xcbc => true,
        0xcbf => true,
        0xcc2 => true,
        0xcc6 => true,
        0xccc...0xccd => true,
        0xcd5...0xcd6 => true,
        0xce2...0xce3 => true,
        0xd00...0xd01 => true,
        0xd3b...0xd3c => true,
        0xd3e => true,
        0xd41...0xd44 => true,
        0xd4d => true,
        0xd57 => true,
        0xd62...0xd63 => true,
        0xd81 => true,
        0xdca => true,
        0xdcf => true,
        0xdd2...0xdd4 => true,
        0xdd6 => true,
        0xddf => true,
        0xe31 => true,
        0xe34...0xe3a => true,
        0xe47...0xe4e => true,
        0xeb1 => true,
        0xeb4...0xebc => true,
        0xec8...0xece => true,
        0xf18...0xf19 => true,
        0xf35 => true,
        0xf37 => true,
        0xf39 => true,
        0xf71...0xf7e => true,
        0xf80...0xf84 => true,
        0xf86...0xf87 => true,
        0xf8d...0xf97 => true,
        0xf99...0xfbc => true,
        0xfc6 => true,
        0x102d...0x1030 => true,
        0x1032...0x1037 => true,
        0x1039...0x103a => true,
        0x103d...0x103e => true,
        0x1058...0x1059 => true,
        0x105e...0x1060 => true,
        0x1071...0x1074 => true,
        0x1082 => true,
        0x1085...0x1086 => true,
        0x108d => true,
        0x109d => true,
        0x135d...0x135f => true,
        0x1712...0x1714 => true,
        0x1732...0x1733 => true,
        0x1752...0x1753 => true,
        0x1772...0x1773 => true,
        0x17b4...0x17b5 => true,
        0x17b7...0x17bd => true,
        0x17c6 => true,
        0x17c9...0x17d3 => true,
        0x17dd => true,
        0x180b...0x180d => true,
        0x180f => true,
        0x1885...0x1886 => true,
        0x18a9 => true,
        0x1920...0x1922 => true,
        0x1927...0x1928 => true,
        0x1932 => true,
        0x1939...0x193b => true,
        0x1a17...0x1a18 => true,
        0x1a1b => true,
        0x1a56 => true,
        0x1a58...0x1a5e => true,
        0x1a60 => true,
        0x1a62 => true,
        0x1a65...0x1a6c => true,
        0x1a73...0x1a7c => true,
        0x1a7f => true,
        0x1ab0...0x1abd => true,
        0x1abe => true,
        0x1abf...0x1ace => true,
        0x1b00...0x1b03 => true,
        0x1b34 => true,
        0x1b35 => true,
        0x1b36...0x1b3a => true,
        0x1b3c => true,
        0x1b42 => true,
        0x1b6b...0x1b73 => true,
        0x1b80...0x1b81 => true,
        0x1ba2...0x1ba5 => true,
        0x1ba8...0x1ba9 => true,
        0x1bab...0x1bad => true,
        0x1be6 => true,
        0x1be8...0x1be9 => true,
        0x1bed => true,
        0x1bef...0x1bf1 => true,
        0x1c2c...0x1c33 => true,
        0x1c36...0x1c37 => true,
        0x1cd0...0x1cd2 => true,
        0x1cd4...0x1ce0 => true,
        0x1ce2...0x1ce8 => true,
        0x1ced => true,
        0x1cf4 => true,
        0x1cf8...0x1cf9 => true,
        0x1dc0...0x1dff => true,
        0x200c => true,
        0x20d0...0x20dc => true,
        0x20dd...0x20e0 => true,
        0x20e1 => true,
        0x20e2...0x20e4 => true,
        0x20e5...0x20f0 => true,
        0x2cef...0x2cf1 => true,
        0x2d7f => true,
        0x2de0...0x2dff => true,
        0x302a...0x302d => true,
        0x302e...0x302f => true,
        0x3099...0x309a => true,
        0xa66f => true,
        0xa670...0xa672 => true,
        0xa674...0xa67d => true,
        0xa69e...0xa69f => true,
        0xa6f0...0xa6f1 => true,
        0xa802 => true,
        0xa806 => true,
        0xa80b => true,
        0xa825...0xa826 => true,
        0xa82c => true,
        0xa8c4...0xa8c5 => true,
        0xa8e0...0xa8f1 => true,
        0xa8ff => true,
        0xa926...0xa92d => true,
        0xa947...0xa951 => true,
        0xa980...0xa982 => true,
        0xa9b3 => true,
        0xa9b6...0xa9b9 => true,
        0xa9bc...0xa9bd => true,
        0xa9e5 => true,
        0xaa29...0xaa2e => true,
        0xaa31...0xaa32 => true,
        0xaa35...0xaa36 => true,
        0xaa43 => true,
        0xaa4c => true,
        0xaa7c => true,
        0xaab0 => true,
        0xaab2...0xaab4 => true,
        0xaab7...0xaab8 => true,
        0xaabe...0xaabf => true,
        0xaac1 => true,
        0xaaec...0xaaed => true,
        0xaaf6 => true,
        0xabe5 => true,
        0xabe8 => true,
        0xabed => true,
        0xfb1e => true,
        0xfe00...0xfe0f => true,
        0xfe20...0xfe2f => true,
        0xff9e...0xff9f => true,
        0x101fd => true,
        0x102e0 => true,
        0x10376...0x1037a => true,
        0x10a01...0x10a03 => true,
        0x10a05...0x10a06 => true,
        0x10a0c...0x10a0f => true,
        0x10a38...0x10a3a => true,
        0x10a3f => true,
        0x10ae5...0x10ae6 => true,
        0x10d24...0x10d27 => true,
        0x10eab...0x10eac => true,
        0x10efd...0x10eff => true,
        0x10f46...0x10f50 => true,
        0x10f82...0x10f85 => true,
        0x11001 => true,
        0x11038...0x11046 => true,
        0x11070 => true,
        0x11073...0x11074 => true,
        0x1107f...0x11081 => true,
        0x110b3...0x110b6 => true,
        0x110b9...0x110ba => true,
        0x110c2 => true,
        0x11100...0x11102 => true,
        0x11127...0x1112b => true,
        0x1112d...0x11134 => true,
        0x11173 => true,
        0x11180...0x11181 => true,
        0x111b6...0x111be => true,
        0x111c9...0x111cc => true,
        0x111cf => true,
        0x1122f...0x11231 => true,
        0x11234 => true,
        0x11236...0x11237 => true,
        0x1123e => true,
        0x11241 => true,
        0x112df => true,
        0x112e3...0x112ea => true,
        0x11300...0x11301 => true,
        0x1133b...0x1133c => true,
        0x1133e => true,
        0x11340 => true,
        0x11357 => true,
        0x11366...0x1136c => true,
        0x11370...0x11374 => true,
        0x11438...0x1143f => true,
        0x11442...0x11444 => true,
        0x11446 => true,
        0x1145e => true,
        0x114b0 => true,
        0x114b3...0x114b8 => true,
        0x114ba => true,
        0x114bd => true,
        0x114bf...0x114c0 => true,
        0x114c2...0x114c3 => true,
        0x115af => true,
        0x115b2...0x115b5 => true,
        0x115bc...0x115bd => true,
        0x115bf...0x115c0 => true,
        0x115dc...0x115dd => true,
        0x11633...0x1163a => true,
        0x1163d => true,
        0x1163f...0x11640 => true,
        0x116ab => true,
        0x116ad => true,
        0x116b0...0x116b5 => true,
        0x116b7 => true,
        0x1171d...0x1171f => true,
        0x11722...0x11725 => true,
        0x11727...0x1172b => true,
        0x1182f...0x11837 => true,
        0x11839...0x1183a => true,
        0x11930 => true,
        0x1193b...0x1193c => true,
        0x1193e => true,
        0x11943 => true,
        0x119d4...0x119d7 => true,
        0x119da...0x119db => true,
        0x119e0 => true,
        0x11a01...0x11a0a => true,
        0x11a33...0x11a38 => true,
        0x11a3b...0x11a3e => true,
        0x11a47 => true,
        0x11a51...0x11a56 => true,
        0x11a59...0x11a5b => true,
        0x11a8a...0x11a96 => true,
        0x11a98...0x11a99 => true,
        0x11c30...0x11c36 => true,
        0x11c38...0x11c3d => true,
        0x11c3f => true,
        0x11c92...0x11ca7 => true,
        0x11caa...0x11cb0 => true,
        0x11cb2...0x11cb3 => true,
        0x11cb5...0x11cb6 => true,
        0x11d31...0x11d36 => true,
        0x11d3a => true,
        0x11d3c...0x11d3d => true,
        0x11d3f...0x11d45 => true,
        0x11d47 => true,
        0x11d90...0x11d91 => true,
        0x11d95 => true,
        0x11d97 => true,
        0x11ef3...0x11ef4 => true,
        0x11f00...0x11f01 => true,
        0x11f36...0x11f3a => true,
        0x11f40 => true,
        0x11f42 => true,
        0x13440 => true,
        0x13447...0x13455 => true,
        0x16af0...0x16af4 => true,
        0x16b30...0x16b36 => true,
        0x16f4f => true,
        0x16f8f...0x16f92 => true,
        0x16fe4 => true,
        0x1bc9d...0x1bc9e => true,
        0x1cf00...0x1cf2d => true,
        0x1cf30...0x1cf46 => true,
        0x1d165 => true,
        0x1d167...0x1d169 => true,
        0x1d16e...0x1d172 => true,
        0x1d17b...0x1d182 => true,
        0x1d185...0x1d18b => true,
        0x1d1aa...0x1d1ad => true,
        0x1d242...0x1d244 => true,
        0x1da00...0x1da36 => true,
        0x1da3b...0x1da6c => true,
        0x1da75 => true,
        0x1da84 => true,
        0x1da9b...0x1da9f => true,
        0x1daa1...0x1daaf => true,
        0x1e000...0x1e006 => true,
        0x1e008...0x1e018 => true,
        0x1e01b...0x1e021 => true,
        0x1e023...0x1e024 => true,
        0x1e026...0x1e02a => true,
        0x1e08f => true,
        0x1e130...0x1e136 => true,
        0x1e2ae => true,
        0x1e2ec...0x1e2ef => true,
        0x1e4ec...0x1e4ef => true,
        0x1e8d0...0x1e8d6 => true,
        0x1e944...0x1e94a => true,
        0x1f3fb...0x1f3ff => true,
        0xe0020...0xe007f => true,
        0xe0100...0xe01ef => true,
        else => false,
    };
}

pub fn isRegionalIndicator(cp: u21) bool {
    if (cp < 0x1f1e6 or cp > 0x1f1ff) return false;

    return switch (cp) {
        0x1f1e6...0x1f1ff => true,
        else => false,
    };
}

pub fn isSpacingmark(cp: u21) bool {
    if (cp < 0x903 or cp > 0x1d16d) return false;

    return switch (cp) {
        0x903 => true,
        0x93b => true,
        0x93e...0x940 => true,
        0x949...0x94c => true,
        0x94e...0x94f => true,
        0x982...0x983 => true,
        0x9bf...0x9c0 => true,
        0x9c7...0x9c8 => true,
        0x9cb...0x9cc => true,
        0xa03 => true,
        0xa3e...0xa40 => true,
        0xa83 => true,
        0xabe...0xac0 => true,
        0xac9 => true,
        0xacb...0xacc => true,
        0xb02...0xb03 => true,
        0xb40 => true,
        0xb47...0xb48 => true,
        0xb4b...0xb4c => true,
        0xbbf => true,
        0xbc1...0xbc2 => true,
        0xbc6...0xbc8 => true,
        0xbca...0xbcc => true,
        0xc01...0xc03 => true,
        0xc41...0xc44 => true,
        0xc82...0xc83 => true,
        0xcbe => true,
        0xcc0...0xcc1 => true,
        0xcc3...0xcc4 => true,
        0xcc7...0xcc8 => true,
        0xcca...0xccb => true,
        0xcf3 => true,
        0xd02...0xd03 => true,
        0xd3f...0xd40 => true,
        0xd46...0xd48 => true,
        0xd4a...0xd4c => true,
        0xd82...0xd83 => true,
        0xdd0...0xdd1 => true,
        0xdd8...0xdde => true,
        0xdf2...0xdf3 => true,
        0xe33 => true,
        0xeb3 => true,
        0xf3e...0xf3f => true,
        0xf7f => true,
        0x1031 => true,
        0x103b...0x103c => true,
        0x1056...0x1057 => true,
        0x1084 => true,
        0x1715 => true,
        0x1734 => true,
        0x17b6 => true,
        0x17be...0x17c5 => true,
        0x17c7...0x17c8 => true,
        0x1923...0x1926 => true,
        0x1929...0x192b => true,
        0x1930...0x1931 => true,
        0x1933...0x1938 => true,
        0x1a19...0x1a1a => true,
        0x1a55 => true,
        0x1a57 => true,
        0x1a6d...0x1a72 => true,
        0x1b04 => true,
        0x1b3b => true,
        0x1b3d...0x1b41 => true,
        0x1b43...0x1b44 => true,
        0x1b82 => true,
        0x1ba1 => true,
        0x1ba6...0x1ba7 => true,
        0x1baa => true,
        0x1be7 => true,
        0x1bea...0x1bec => true,
        0x1bee => true,
        0x1bf2...0x1bf3 => true,
        0x1c24...0x1c2b => true,
        0x1c34...0x1c35 => true,
        0x1ce1 => true,
        0x1cf7 => true,
        0xa823...0xa824 => true,
        0xa827 => true,
        0xa880...0xa881 => true,
        0xa8b4...0xa8c3 => true,
        0xa952...0xa953 => true,
        0xa983 => true,
        0xa9b4...0xa9b5 => true,
        0xa9ba...0xa9bb => true,
        0xa9be...0xa9c0 => true,
        0xaa2f...0xaa30 => true,
        0xaa33...0xaa34 => true,
        0xaa4d => true,
        0xaaeb => true,
        0xaaee...0xaaef => true,
        0xaaf5 => true,
        0xabe3...0xabe4 => true,
        0xabe6...0xabe7 => true,
        0xabe9...0xabea => true,
        0xabec => true,
        0x11000 => true,
        0x11002 => true,
        0x11082 => true,
        0x110b0...0x110b2 => true,
        0x110b7...0x110b8 => true,
        0x1112c => true,
        0x11145...0x11146 => true,
        0x11182 => true,
        0x111b3...0x111b5 => true,
        0x111bf...0x111c0 => true,
        0x111ce => true,
        0x1122c...0x1122e => true,
        0x11232...0x11233 => true,
        0x11235 => true,
        0x112e0...0x112e2 => true,
        0x11302...0x11303 => true,
        0x1133f => true,
        0x11341...0x11344 => true,
        0x11347...0x11348 => true,
        0x1134b...0x1134d => true,
        0x11362...0x11363 => true,
        0x11435...0x11437 => true,
        0x11440...0x11441 => true,
        0x11445 => true,
        0x114b1...0x114b2 => true,
        0x114b9 => true,
        0x114bb...0x114bc => true,
        0x114be => true,
        0x114c1 => true,
        0x115b0...0x115b1 => true,
        0x115b8...0x115bb => true,
        0x115be => true,
        0x11630...0x11632 => true,
        0x1163b...0x1163c => true,
        0x1163e => true,
        0x116ac => true,
        0x116ae...0x116af => true,
        0x116b6 => true,
        0x11726 => true,
        0x1182c...0x1182e => true,
        0x11838 => true,
        0x11931...0x11935 => true,
        0x11937...0x11938 => true,
        0x1193d => true,
        0x11940 => true,
        0x11942 => true,
        0x119d1...0x119d3 => true,
        0x119dc...0x119df => true,
        0x119e4 => true,
        0x11a39 => true,
        0x11a57...0x11a58 => true,
        0x11a97 => true,
        0x11c2f => true,
        0x11c3e => true,
        0x11ca9 => true,
        0x11cb1 => true,
        0x11cb4 => true,
        0x11d8a...0x11d8e => true,
        0x11d93...0x11d94 => true,
        0x11d96 => true,
        0x11ef5...0x11ef6 => true,
        0x11f03 => true,
        0x11f34...0x11f35 => true,
        0x11f3e...0x11f3f => true,
        0x11f41 => true,
        0x16f51...0x16f87 => true,
        0x16ff0...0x16ff1 => true,
        0x1d166 => true,
        0x1d16d => true,
        else => false,
    };
}

pub fn isL(cp: u21) bool {
    if (cp < 0x1100 or cp > 0xa97c) return false;

    return switch (cp) {
        0x1100...0x115f => true,
        0xa960...0xa97c => true,
        else => false,
    };
}

pub fn isV(cp: u21) bool {
    if (cp < 0x1160 or cp > 0xd7c6) return false;

    return switch (cp) {
        0x1160...0x11a7 => true,
        0xd7b0...0xd7c6 => true,
        else => false,
    };
}

pub fn isT(cp: u21) bool {
    if (cp < 0x11a8 or cp > 0xd7fb) return false;

    return switch (cp) {
        0x11a8...0x11ff => true,
        0xd7cb...0xd7fb => true,
        else => false,
    };
}

pub fn isLv(cp: u21) bool {
    if (cp < 0xac00 or cp > 0xd788) return false;

    return switch (cp) {
        0xac00 => true,
        0xac1c => true,
        0xac38 => true,
        0xac54 => true,
        0xac70 => true,
        0xac8c => true,
        0xaca8 => true,
        0xacc4 => true,
        0xace0 => true,
        0xacfc => true,
        0xad18 => true,
        0xad34 => true,
        0xad50 => true,
        0xad6c => true,
        0xad88 => true,
        0xada4 => true,
        0xadc0 => true,
        0xaddc => true,
        0xadf8 => true,
        0xae14 => true,
        0xae30 => true,
        0xae4c => true,
        0xae68 => true,
        0xae84 => true,
        0xaea0 => true,
        0xaebc => true,
        0xaed8 => true,
        0xaef4 => true,
        0xaf10 => true,
        0xaf2c => true,
        0xaf48 => true,
        0xaf64 => true,
        0xaf80 => true,
        0xaf9c => true,
        0xafb8 => true,
        0xafd4 => true,
        0xaff0 => true,
        0xb00c => true,
        0xb028 => true,
        0xb044 => true,
        0xb060 => true,
        0xb07c => true,
        0xb098 => true,
        0xb0b4 => true,
        0xb0d0 => true,
        0xb0ec => true,
        0xb108 => true,
        0xb124 => true,
        0xb140 => true,
        0xb15c => true,
        0xb178 => true,
        0xb194 => true,
        0xb1b0 => true,
        0xb1cc => true,
        0xb1e8 => true,
        0xb204 => true,
        0xb220 => true,
        0xb23c => true,
        0xb258 => true,
        0xb274 => true,
        0xb290 => true,
        0xb2ac => true,
        0xb2c8 => true,
        0xb2e4 => true,
        0xb300 => true,
        0xb31c => true,
        0xb338 => true,
        0xb354 => true,
        0xb370 => true,
        0xb38c => true,
        0xb3a8 => true,
        0xb3c4 => true,
        0xb3e0 => true,
        0xb3fc => true,
        0xb418 => true,
        0xb434 => true,
        0xb450 => true,
        0xb46c => true,
        0xb488 => true,
        0xb4a4 => true,
        0xb4c0 => true,
        0xb4dc => true,
        0xb4f8 => true,
        0xb514 => true,
        0xb530 => true,
        0xb54c => true,
        0xb568 => true,
        0xb584 => true,
        0xb5a0 => true,
        0xb5bc => true,
        0xb5d8 => true,
        0xb5f4 => true,
        0xb610 => true,
        0xb62c => true,
        0xb648 => true,
        0xb664 => true,
        0xb680 => true,
        0xb69c => true,
        0xb6b8 => true,
        0xb6d4 => true,
        0xb6f0 => true,
        0xb70c => true,
        0xb728 => true,
        0xb744 => true,
        0xb760 => true,
        0xb77c => true,
        0xb798 => true,
        0xb7b4 => true,
        0xb7d0 => true,
        0xb7ec => true,
        0xb808 => true,
        0xb824 => true,
        0xb840 => true,
        0xb85c => true,
        0xb878 => true,
        0xb894 => true,
        0xb8b0 => true,
        0xb8cc => true,
        0xb8e8 => true,
        0xb904 => true,
        0xb920 => true,
        0xb93c => true,
        0xb958 => true,
        0xb974 => true,
        0xb990 => true,
        0xb9ac => true,
        0xb9c8 => true,
        0xb9e4 => true,
        0xba00 => true,
        0xba1c => true,
        0xba38 => true,
        0xba54 => true,
        0xba70 => true,
        0xba8c => true,
        0xbaa8 => true,
        0xbac4 => true,
        0xbae0 => true,
        0xbafc => true,
        0xbb18 => true,
        0xbb34 => true,
        0xbb50 => true,
        0xbb6c => true,
        0xbb88 => true,
        0xbba4 => true,
        0xbbc0 => true,
        0xbbdc => true,
        0xbbf8 => true,
        0xbc14 => true,
        0xbc30 => true,
        0xbc4c => true,
        0xbc68 => true,
        0xbc84 => true,
        0xbca0 => true,
        0xbcbc => true,
        0xbcd8 => true,
        0xbcf4 => true,
        0xbd10 => true,
        0xbd2c => true,
        0xbd48 => true,
        0xbd64 => true,
        0xbd80 => true,
        0xbd9c => true,
        0xbdb8 => true,
        0xbdd4 => true,
        0xbdf0 => true,
        0xbe0c => true,
        0xbe28 => true,
        0xbe44 => true,
        0xbe60 => true,
        0xbe7c => true,
        0xbe98 => true,
        0xbeb4 => true,
        0xbed0 => true,
        0xbeec => true,
        0xbf08 => true,
        0xbf24 => true,
        0xbf40 => true,
        0xbf5c => true,
        0xbf78 => true,
        0xbf94 => true,
        0xbfb0 => true,
        0xbfcc => true,
        0xbfe8 => true,
        0xc004 => true,
        0xc020 => true,
        0xc03c => true,
        0xc058 => true,
        0xc074 => true,
        0xc090 => true,
        0xc0ac => true,
        0xc0c8 => true,
        0xc0e4 => true,
        0xc100 => true,
        0xc11c => true,
        0xc138 => true,
        0xc154 => true,
        0xc170 => true,
        0xc18c => true,
        0xc1a8 => true,
        0xc1c4 => true,
        0xc1e0 => true,
        0xc1fc => true,
        0xc218 => true,
        0xc234 => true,
        0xc250 => true,
        0xc26c => true,
        0xc288 => true,
        0xc2a4 => true,
        0xc2c0 => true,
        0xc2dc => true,
        0xc2f8 => true,
        0xc314 => true,
        0xc330 => true,
        0xc34c => true,
        0xc368 => true,
        0xc384 => true,
        0xc3a0 => true,
        0xc3bc => true,
        0xc3d8 => true,
        0xc3f4 => true,
        0xc410 => true,
        0xc42c => true,
        0xc448 => true,
        0xc464 => true,
        0xc480 => true,
        0xc49c => true,
        0xc4b8 => true,
        0xc4d4 => true,
        0xc4f0 => true,
        0xc50c => true,
        0xc528 => true,
        0xc544 => true,
        0xc560 => true,
        0xc57c => true,
        0xc598 => true,
        0xc5b4 => true,
        0xc5d0 => true,
        0xc5ec => true,
        0xc608 => true,
        0xc624 => true,
        0xc640 => true,
        0xc65c => true,
        0xc678 => true,
        0xc694 => true,
        0xc6b0 => true,
        0xc6cc => true,
        0xc6e8 => true,
        0xc704 => true,
        0xc720 => true,
        0xc73c => true,
        0xc758 => true,
        0xc774 => true,
        0xc790 => true,
        0xc7ac => true,
        0xc7c8 => true,
        0xc7e4 => true,
        0xc800 => true,
        0xc81c => true,
        0xc838 => true,
        0xc854 => true,
        0xc870 => true,
        0xc88c => true,
        0xc8a8 => true,
        0xc8c4 => true,
        0xc8e0 => true,
        0xc8fc => true,
        0xc918 => true,
        0xc934 => true,
        0xc950 => true,
        0xc96c => true,
        0xc988 => true,
        0xc9a4 => true,
        0xc9c0 => true,
        0xc9dc => true,
        0xc9f8 => true,
        0xca14 => true,
        0xca30 => true,
        0xca4c => true,
        0xca68 => true,
        0xca84 => true,
        0xcaa0 => true,
        0xcabc => true,
        0xcad8 => true,
        0xcaf4 => true,
        0xcb10 => true,
        0xcb2c => true,
        0xcb48 => true,
        0xcb64 => true,
        0xcb80 => true,
        0xcb9c => true,
        0xcbb8 => true,
        0xcbd4 => true,
        0xcbf0 => true,
        0xcc0c => true,
        0xcc28 => true,
        0xcc44 => true,
        0xcc60 => true,
        0xcc7c => true,
        0xcc98 => true,
        0xccb4 => true,
        0xccd0 => true,
        0xccec => true,
        0xcd08 => true,
        0xcd24 => true,
        0xcd40 => true,
        0xcd5c => true,
        0xcd78 => true,
        0xcd94 => true,
        0xcdb0 => true,
        0xcdcc => true,
        0xcde8 => true,
        0xce04 => true,
        0xce20 => true,
        0xce3c => true,
        0xce58 => true,
        0xce74 => true,
        0xce90 => true,
        0xceac => true,
        0xcec8 => true,
        0xcee4 => true,
        0xcf00 => true,
        0xcf1c => true,
        0xcf38 => true,
        0xcf54 => true,
        0xcf70 => true,
        0xcf8c => true,
        0xcfa8 => true,
        0xcfc4 => true,
        0xcfe0 => true,
        0xcffc => true,
        0xd018 => true,
        0xd034 => true,
        0xd050 => true,
        0xd06c => true,
        0xd088 => true,
        0xd0a4 => true,
        0xd0c0 => true,
        0xd0dc => true,
        0xd0f8 => true,
        0xd114 => true,
        0xd130 => true,
        0xd14c => true,
        0xd168 => true,
        0xd184 => true,
        0xd1a0 => true,
        0xd1bc => true,
        0xd1d8 => true,
        0xd1f4 => true,
        0xd210 => true,
        0xd22c => true,
        0xd248 => true,
        0xd264 => true,
        0xd280 => true,
        0xd29c => true,
        0xd2b8 => true,
        0xd2d4 => true,
        0xd2f0 => true,
        0xd30c => true,
        0xd328 => true,
        0xd344 => true,
        0xd360 => true,
        0xd37c => true,
        0xd398 => true,
        0xd3b4 => true,
        0xd3d0 => true,
        0xd3ec => true,
        0xd408 => true,
        0xd424 => true,
        0xd440 => true,
        0xd45c => true,
        0xd478 => true,
        0xd494 => true,
        0xd4b0 => true,
        0xd4cc => true,
        0xd4e8 => true,
        0xd504 => true,
        0xd520 => true,
        0xd53c => true,
        0xd558 => true,
        0xd574 => true,
        0xd590 => true,
        0xd5ac => true,
        0xd5c8 => true,
        0xd5e4 => true,
        0xd600 => true,
        0xd61c => true,
        0xd638 => true,
        0xd654 => true,
        0xd670 => true,
        0xd68c => true,
        0xd6a8 => true,
        0xd6c4 => true,
        0xd6e0 => true,
        0xd6fc => true,
        0xd718 => true,
        0xd734 => true,
        0xd750 => true,
        0xd76c => true,
        0xd788 => true,
        else => false,
    };
}

pub fn isLvt(cp: u21) bool {
    if (cp < 0xac01 or cp > 0xd7a3) return false;

    return switch (cp) {
        0xac01...0xac1b => true,
        0xac1d...0xac37 => true,
        0xac39...0xac53 => true,
        0xac55...0xac6f => true,
        0xac71...0xac8b => true,
        0xac8d...0xaca7 => true,
        0xaca9...0xacc3 => true,
        0xacc5...0xacdf => true,
        0xace1...0xacfb => true,
        0xacfd...0xad17 => true,
        0xad19...0xad33 => true,
        0xad35...0xad4f => true,
        0xad51...0xad6b => true,
        0xad6d...0xad87 => true,
        0xad89...0xada3 => true,
        0xada5...0xadbf => true,
        0xadc1...0xaddb => true,
        0xaddd...0xadf7 => true,
        0xadf9...0xae13 => true,
        0xae15...0xae2f => true,
        0xae31...0xae4b => true,
        0xae4d...0xae67 => true,
        0xae69...0xae83 => true,
        0xae85...0xae9f => true,
        0xaea1...0xaebb => true,
        0xaebd...0xaed7 => true,
        0xaed9...0xaef3 => true,
        0xaef5...0xaf0f => true,
        0xaf11...0xaf2b => true,
        0xaf2d...0xaf47 => true,
        0xaf49...0xaf63 => true,
        0xaf65...0xaf7f => true,
        0xaf81...0xaf9b => true,
        0xaf9d...0xafb7 => true,
        0xafb9...0xafd3 => true,
        0xafd5...0xafef => true,
        0xaff1...0xb00b => true,
        0xb00d...0xb027 => true,
        0xb029...0xb043 => true,
        0xb045...0xb05f => true,
        0xb061...0xb07b => true,
        0xb07d...0xb097 => true,
        0xb099...0xb0b3 => true,
        0xb0b5...0xb0cf => true,
        0xb0d1...0xb0eb => true,
        0xb0ed...0xb107 => true,
        0xb109...0xb123 => true,
        0xb125...0xb13f => true,
        0xb141...0xb15b => true,
        0xb15d...0xb177 => true,
        0xb179...0xb193 => true,
        0xb195...0xb1af => true,
        0xb1b1...0xb1cb => true,
        0xb1cd...0xb1e7 => true,
        0xb1e9...0xb203 => true,
        0xb205...0xb21f => true,
        0xb221...0xb23b => true,
        0xb23d...0xb257 => true,
        0xb259...0xb273 => true,
        0xb275...0xb28f => true,
        0xb291...0xb2ab => true,
        0xb2ad...0xb2c7 => true,
        0xb2c9...0xb2e3 => true,
        0xb2e5...0xb2ff => true,
        0xb301...0xb31b => true,
        0xb31d...0xb337 => true,
        0xb339...0xb353 => true,
        0xb355...0xb36f => true,
        0xb371...0xb38b => true,
        0xb38d...0xb3a7 => true,
        0xb3a9...0xb3c3 => true,
        0xb3c5...0xb3df => true,
        0xb3e1...0xb3fb => true,
        0xb3fd...0xb417 => true,
        0xb419...0xb433 => true,
        0xb435...0xb44f => true,
        0xb451...0xb46b => true,
        0xb46d...0xb487 => true,
        0xb489...0xb4a3 => true,
        0xb4a5...0xb4bf => true,
        0xb4c1...0xb4db => true,
        0xb4dd...0xb4f7 => true,
        0xb4f9...0xb513 => true,
        0xb515...0xb52f => true,
        0xb531...0xb54b => true,
        0xb54d...0xb567 => true,
        0xb569...0xb583 => true,
        0xb585...0xb59f => true,
        0xb5a1...0xb5bb => true,
        0xb5bd...0xb5d7 => true,
        0xb5d9...0xb5f3 => true,
        0xb5f5...0xb60f => true,
        0xb611...0xb62b => true,
        0xb62d...0xb647 => true,
        0xb649...0xb663 => true,
        0xb665...0xb67f => true,
        0xb681...0xb69b => true,
        0xb69d...0xb6b7 => true,
        0xb6b9...0xb6d3 => true,
        0xb6d5...0xb6ef => true,
        0xb6f1...0xb70b => true,
        0xb70d...0xb727 => true,
        0xb729...0xb743 => true,
        0xb745...0xb75f => true,
        0xb761...0xb77b => true,
        0xb77d...0xb797 => true,
        0xb799...0xb7b3 => true,
        0xb7b5...0xb7cf => true,
        0xb7d1...0xb7eb => true,
        0xb7ed...0xb807 => true,
        0xb809...0xb823 => true,
        0xb825...0xb83f => true,
        0xb841...0xb85b => true,
        0xb85d...0xb877 => true,
        0xb879...0xb893 => true,
        0xb895...0xb8af => true,
        0xb8b1...0xb8cb => true,
        0xb8cd...0xb8e7 => true,
        0xb8e9...0xb903 => true,
        0xb905...0xb91f => true,
        0xb921...0xb93b => true,
        0xb93d...0xb957 => true,
        0xb959...0xb973 => true,
        0xb975...0xb98f => true,
        0xb991...0xb9ab => true,
        0xb9ad...0xb9c7 => true,
        0xb9c9...0xb9e3 => true,
        0xb9e5...0xb9ff => true,
        0xba01...0xba1b => true,
        0xba1d...0xba37 => true,
        0xba39...0xba53 => true,
        0xba55...0xba6f => true,
        0xba71...0xba8b => true,
        0xba8d...0xbaa7 => true,
        0xbaa9...0xbac3 => true,
        0xbac5...0xbadf => true,
        0xbae1...0xbafb => true,
        0xbafd...0xbb17 => true,
        0xbb19...0xbb33 => true,
        0xbb35...0xbb4f => true,
        0xbb51...0xbb6b => true,
        0xbb6d...0xbb87 => true,
        0xbb89...0xbba3 => true,
        0xbba5...0xbbbf => true,
        0xbbc1...0xbbdb => true,
        0xbbdd...0xbbf7 => true,
        0xbbf9...0xbc13 => true,
        0xbc15...0xbc2f => true,
        0xbc31...0xbc4b => true,
        0xbc4d...0xbc67 => true,
        0xbc69...0xbc83 => true,
        0xbc85...0xbc9f => true,
        0xbca1...0xbcbb => true,
        0xbcbd...0xbcd7 => true,
        0xbcd9...0xbcf3 => true,
        0xbcf5...0xbd0f => true,
        0xbd11...0xbd2b => true,
        0xbd2d...0xbd47 => true,
        0xbd49...0xbd63 => true,
        0xbd65...0xbd7f => true,
        0xbd81...0xbd9b => true,
        0xbd9d...0xbdb7 => true,
        0xbdb9...0xbdd3 => true,
        0xbdd5...0xbdef => true,
        0xbdf1...0xbe0b => true,
        0xbe0d...0xbe27 => true,
        0xbe29...0xbe43 => true,
        0xbe45...0xbe5f => true,
        0xbe61...0xbe7b => true,
        0xbe7d...0xbe97 => true,
        0xbe99...0xbeb3 => true,
        0xbeb5...0xbecf => true,
        0xbed1...0xbeeb => true,
        0xbeed...0xbf07 => true,
        0xbf09...0xbf23 => true,
        0xbf25...0xbf3f => true,
        0xbf41...0xbf5b => true,
        0xbf5d...0xbf77 => true,
        0xbf79...0xbf93 => true,
        0xbf95...0xbfaf => true,
        0xbfb1...0xbfcb => true,
        0xbfcd...0xbfe7 => true,
        0xbfe9...0xc003 => true,
        0xc005...0xc01f => true,
        0xc021...0xc03b => true,
        0xc03d...0xc057 => true,
        0xc059...0xc073 => true,
        0xc075...0xc08f => true,
        0xc091...0xc0ab => true,
        0xc0ad...0xc0c7 => true,
        0xc0c9...0xc0e3 => true,
        0xc0e5...0xc0ff => true,
        0xc101...0xc11b => true,
        0xc11d...0xc137 => true,
        0xc139...0xc153 => true,
        0xc155...0xc16f => true,
        0xc171...0xc18b => true,
        0xc18d...0xc1a7 => true,
        0xc1a9...0xc1c3 => true,
        0xc1c5...0xc1df => true,
        0xc1e1...0xc1fb => true,
        0xc1fd...0xc217 => true,
        0xc219...0xc233 => true,
        0xc235...0xc24f => true,
        0xc251...0xc26b => true,
        0xc26d...0xc287 => true,
        0xc289...0xc2a3 => true,
        0xc2a5...0xc2bf => true,
        0xc2c1...0xc2db => true,
        0xc2dd...0xc2f7 => true,
        0xc2f9...0xc313 => true,
        0xc315...0xc32f => true,
        0xc331...0xc34b => true,
        0xc34d...0xc367 => true,
        0xc369...0xc383 => true,
        0xc385...0xc39f => true,
        0xc3a1...0xc3bb => true,
        0xc3bd...0xc3d7 => true,
        0xc3d9...0xc3f3 => true,
        0xc3f5...0xc40f => true,
        0xc411...0xc42b => true,
        0xc42d...0xc447 => true,
        0xc449...0xc463 => true,
        0xc465...0xc47f => true,
        0xc481...0xc49b => true,
        0xc49d...0xc4b7 => true,
        0xc4b9...0xc4d3 => true,
        0xc4d5...0xc4ef => true,
        0xc4f1...0xc50b => true,
        0xc50d...0xc527 => true,
        0xc529...0xc543 => true,
        0xc545...0xc55f => true,
        0xc561...0xc57b => true,
        0xc57d...0xc597 => true,
        0xc599...0xc5b3 => true,
        0xc5b5...0xc5cf => true,
        0xc5d1...0xc5eb => true,
        0xc5ed...0xc607 => true,
        0xc609...0xc623 => true,
        0xc625...0xc63f => true,
        0xc641...0xc65b => true,
        0xc65d...0xc677 => true,
        0xc679...0xc693 => true,
        0xc695...0xc6af => true,
        0xc6b1...0xc6cb => true,
        0xc6cd...0xc6e7 => true,
        0xc6e9...0xc703 => true,
        0xc705...0xc71f => true,
        0xc721...0xc73b => true,
        0xc73d...0xc757 => true,
        0xc759...0xc773 => true,
        0xc775...0xc78f => true,
        0xc791...0xc7ab => true,
        0xc7ad...0xc7c7 => true,
        0xc7c9...0xc7e3 => true,
        0xc7e5...0xc7ff => true,
        0xc801...0xc81b => true,
        0xc81d...0xc837 => true,
        0xc839...0xc853 => true,
        0xc855...0xc86f => true,
        0xc871...0xc88b => true,
        0xc88d...0xc8a7 => true,
        0xc8a9...0xc8c3 => true,
        0xc8c5...0xc8df => true,
        0xc8e1...0xc8fb => true,
        0xc8fd...0xc917 => true,
        0xc919...0xc933 => true,
        0xc935...0xc94f => true,
        0xc951...0xc96b => true,
        0xc96d...0xc987 => true,
        0xc989...0xc9a3 => true,
        0xc9a5...0xc9bf => true,
        0xc9c1...0xc9db => true,
        0xc9dd...0xc9f7 => true,
        0xc9f9...0xca13 => true,
        0xca15...0xca2f => true,
        0xca31...0xca4b => true,
        0xca4d...0xca67 => true,
        0xca69...0xca83 => true,
        0xca85...0xca9f => true,
        0xcaa1...0xcabb => true,
        0xcabd...0xcad7 => true,
        0xcad9...0xcaf3 => true,
        0xcaf5...0xcb0f => true,
        0xcb11...0xcb2b => true,
        0xcb2d...0xcb47 => true,
        0xcb49...0xcb63 => true,
        0xcb65...0xcb7f => true,
        0xcb81...0xcb9b => true,
        0xcb9d...0xcbb7 => true,
        0xcbb9...0xcbd3 => true,
        0xcbd5...0xcbef => true,
        0xcbf1...0xcc0b => true,
        0xcc0d...0xcc27 => true,
        0xcc29...0xcc43 => true,
        0xcc45...0xcc5f => true,
        0xcc61...0xcc7b => true,
        0xcc7d...0xcc97 => true,
        0xcc99...0xccb3 => true,
        0xccb5...0xcccf => true,
        0xccd1...0xcceb => true,
        0xcced...0xcd07 => true,
        0xcd09...0xcd23 => true,
        0xcd25...0xcd3f => true,
        0xcd41...0xcd5b => true,
        0xcd5d...0xcd77 => true,
        0xcd79...0xcd93 => true,
        0xcd95...0xcdaf => true,
        0xcdb1...0xcdcb => true,
        0xcdcd...0xcde7 => true,
        0xcde9...0xce03 => true,
        0xce05...0xce1f => true,
        0xce21...0xce3b => true,
        0xce3d...0xce57 => true,
        0xce59...0xce73 => true,
        0xce75...0xce8f => true,
        0xce91...0xceab => true,
        0xcead...0xcec7 => true,
        0xcec9...0xcee3 => true,
        0xcee5...0xceff => true,
        0xcf01...0xcf1b => true,
        0xcf1d...0xcf37 => true,
        0xcf39...0xcf53 => true,
        0xcf55...0xcf6f => true,
        0xcf71...0xcf8b => true,
        0xcf8d...0xcfa7 => true,
        0xcfa9...0xcfc3 => true,
        0xcfc5...0xcfdf => true,
        0xcfe1...0xcffb => true,
        0xcffd...0xd017 => true,
        0xd019...0xd033 => true,
        0xd035...0xd04f => true,
        0xd051...0xd06b => true,
        0xd06d...0xd087 => true,
        0xd089...0xd0a3 => true,
        0xd0a5...0xd0bf => true,
        0xd0c1...0xd0db => true,
        0xd0dd...0xd0f7 => true,
        0xd0f9...0xd113 => true,
        0xd115...0xd12f => true,
        0xd131...0xd14b => true,
        0xd14d...0xd167 => true,
        0xd169...0xd183 => true,
        0xd185...0xd19f => true,
        0xd1a1...0xd1bb => true,
        0xd1bd...0xd1d7 => true,
        0xd1d9...0xd1f3 => true,
        0xd1f5...0xd20f => true,
        0xd211...0xd22b => true,
        0xd22d...0xd247 => true,
        0xd249...0xd263 => true,
        0xd265...0xd27f => true,
        0xd281...0xd29b => true,
        0xd29d...0xd2b7 => true,
        0xd2b9...0xd2d3 => true,
        0xd2d5...0xd2ef => true,
        0xd2f1...0xd30b => true,
        0xd30d...0xd327 => true,
        0xd329...0xd343 => true,
        0xd345...0xd35f => true,
        0xd361...0xd37b => true,
        0xd37d...0xd397 => true,
        0xd399...0xd3b3 => true,
        0xd3b5...0xd3cf => true,
        0xd3d1...0xd3eb => true,
        0xd3ed...0xd407 => true,
        0xd409...0xd423 => true,
        0xd425...0xd43f => true,
        0xd441...0xd45b => true,
        0xd45d...0xd477 => true,
        0xd479...0xd493 => true,
        0xd495...0xd4af => true,
        0xd4b1...0xd4cb => true,
        0xd4cd...0xd4e7 => true,
        0xd4e9...0xd503 => true,
        0xd505...0xd51f => true,
        0xd521...0xd53b => true,
        0xd53d...0xd557 => true,
        0xd559...0xd573 => true,
        0xd575...0xd58f => true,
        0xd591...0xd5ab => true,
        0xd5ad...0xd5c7 => true,
        0xd5c9...0xd5e3 => true,
        0xd5e5...0xd5ff => true,
        0xd601...0xd61b => true,
        0xd61d...0xd637 => true,
        0xd639...0xd653 => true,
        0xd655...0xd66f => true,
        0xd671...0xd68b => true,
        0xd68d...0xd6a7 => true,
        0xd6a9...0xd6c3 => true,
        0xd6c5...0xd6df => true,
        0xd6e1...0xd6fb => true,
        0xd6fd...0xd717 => true,
        0xd719...0xd733 => true,
        0xd735...0xd74f => true,
        0xd751...0xd76b => true,
        0xd76d...0xd787 => true,
        0xd789...0xd7a3 => true,
        else => false,
    };
}

pub fn isZwj(cp: u21) bool {
    return cp == 0x200d;
}
