/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import org.eso.gasgano.datamodel.Observation;
import org.eso.gasgano.datamodel.ObservationDescription;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.SortedHashtable;

public class Program {
    private String id = null;
    private String desc = null;
    private static ObservationDescription obsDescFactory = null;
    private SortedHashtable observations = null;
    private SortedHashtable directory = null;
    private SortedHashtable telescope = null;

    public Program(String name) {
        this.id = name;
        this.observations = new SortedHashtable();
    }

    public static void setDefaultObservationDescription(ObservationDescription p) {
        obsDescFactory = p;
    }

    public static ObservationDescription getDefaultObservationDescription() {
        return obsDescFactory;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        String rc = this.desc;
        if (rc == null) {
            rc = this.getId();
        }
        return rc;
    }

    public void setDescription(String s) {
        this.desc = s;
    }

    public Observation addObservation(String id, OBComponent obc) {
        Observation rc = this.findObservation(id);
        if (rc == null) {
            rc = new Observation(id);
            if (PropertyDB.getInstance().isDebug(1)) {
                System.out.println("Observation " + id + " Added to Prog " + this.id);
            }
            if (obsDescFactory != null) {
                obsDescFactory.setDescription(rc, obc);
            }
            this.observations.put(id, rc);
        }
        return rc;
    }

    public void removeObservation(String id) {
        this.observations.remove(id);
    }

    public Observation findObservation(String id) {
        return (Observation)this.observations.get(id);
    }

    public boolean isEmpty() {
        return this.observations.isEmpty();
    }

    public SortedHashtable getObservationSet() {
        return this.observations;
    }

    public Observation getObservationAt(int i) {
        return (Observation)this.observations.elementAt(i);
    }

    public int getIndexOfObservation(Observation obs) {
        return this.observations.indexOf(obs);
    }

    public int getObservationCount() {
        return this.observations.size();
    }

    public void cleanup() {
        this.observations.clear();
    }

    public void setTelescope(SortedHashtable telescope) {
        this.telescope = telescope;
    }

    public SortedHashtable getTelescope() {
        return this.telescope;
    }

    public void setDirectory(SortedHashtable directory) {
        this.directory = directory;
    }

    public SortedHashtable getDirectory() {
        return this.directory;
    }
}

