/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.eso.cpl.gui.RecipeDisplay;
import org.eso.cpl.gui.RecipeTree;

public abstract class RecipeSelector
extends JPanel {
    private final RecipeTree tree_;
    private final RecipeDisplay display_;
    private Recipe selectedRecipe_ = null;
    private boolean hasCancelSelection = true;

    public RecipeSelector() {
        this(true);
    }

    public RecipeSelector(boolean cancelSelection) {
        super(new BorderLayout());
        this.hasCancelSelection = cancelSelection;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JSplitPane splitter = new JSplitPane(0);
        splitter.setResizeWeight(0.5);
        this.add((Component)splitter, "Center");
        this.tree_ = new RecipeTree();
        JScrollPane tscroller = new JScrollPane(this.tree_);
        tscroller.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        splitter.setTopComponent(tscroller);
        this.display_ = new RecipeDisplay();
        splitter.setBottomComponent(this.display_);
        this.setPreferredSize(new Dimension(500, 400));
        final AbstractAction okAction = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RecipeSelector.this.approveSelection();
            }
        };
        okAction.setEnabled(false);
        JButton cancelButton = null;
        if (this.hasCancelSelection) {
            AbstractAction cancelAction = new AbstractAction("Cancel"){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RecipeSelector.this.cancelSelection();
                }
            };
            cancelButton = new JButton(cancelAction);
        }
        Box bottomBox = Box.createVerticalBox();
        bottomBox.add(Box.createVerticalStrut(10));
        this.add((Component)bottomBox, "South");
        Box controlBox = Box.createHorizontalBox();
        bottomBox.add(controlBox);
        JButton okButton = new JButton(okAction);
        controlBox.add(Box.createHorizontalGlue());
        controlBox.add(okButton);
        bottomBox.add(Box.createVerticalStrut(5));
        if (this.hasCancelSelection) {
            controlBox.add(cancelButton);
        }
        controlBox.add(Box.createHorizontalStrut(5));
        this.tree_.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                Object uo = RecipeSelector.this.tree_.getUserObject(evt.getPath().getLastPathComponent());
                RecipeSelector.this.selectedRecipe_ = uo instanceof Recipe ? (Recipe)uo : null;
                RecipeSelector.this.display_.setRecipe(RecipeSelector.this.selectedRecipe_);
                okAction.setEnabled(RecipeSelector.this.selectedRecipe_ != null);
            }
        });
    }

    public RecipeSelector(RecipeLibrary[] libs) {
        this(libs, true);
    }

    public RecipeSelector(RecipeLibrary[] libs, boolean hasCancelSelection) {
        this(hasCancelSelection);
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                this.tree_.addLibrary(libs[i]);
            }
        }
    }

    public Recipe getSelectedRecipe() {
        return this.selectedRecipe_;
    }

    protected abstract void approveSelection();

    protected abstract void cancelSelection();

    public RecipeDisplay getDisplay() {
        return this.display_;
    }

    public RecipeTree getTree() {
        return this.tree_;
    }
}

