/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v1.xml.DomParseUtils;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class C3P0ConfigXmlUtils {
    public static final String XML_CONFIG_RSRC_PATH = "/c3p0-config.xml";
    static final MLogger logger;
    public static final String LINESEP;
    private static final String[] MISSPELL_PFXS;
    private static final char[] MISSPELL_LINES;
    private static final String[] MISSPELL_CONFIG;
    private static final String[] MISSPELL_XML;

    private static final void warnCommonXmlConfigResourceMisspellings() {
        if (logger.isLoggable(MLevel.WARNING)) {
            int lena = MISSPELL_PFXS.length;
            for (int a2 = 0; a2 < lena; ++a2) {
                StringBuffer sb = new StringBuffer(16);
                sb.append(MISSPELL_PFXS[a2]);
                int lenb = MISSPELL_LINES.length;
                for (int b2 = 0; b2 < lenb; ++b2) {
                    sb.append(MISSPELL_LINES[b2]);
                    int lenc = MISSPELL_CONFIG.length;
                    for (int c2 = 0; c2 < lenc; ++c2) {
                        sb.append(MISSPELL_CONFIG[c2]);
                        sb.append('.');
                        int lend = MISSPELL_XML.length;
                        for (int d2 = 0; d2 < lend; ++d2) {
                            URL hopefullyNull;
                            sb.append(MISSPELL_XML[d2]);
                            String test = sb.toString();
                            if (test.equals(XML_CONFIG_RSRC_PATH) || (hopefullyNull = (class$com$mchange$v2$c3p0$cfg$C3P0ConfigXmlUtils == null ? C3P0ConfigXmlUtils.class$("com.mchange.v2.c3p0.cfg.C3P0ConfigXmlUtils") : class$com$mchange$v2$c3p0$cfg$C3P0ConfigXmlUtils).getResource(test)) == null) continue;
                            logger.warning("POSSIBLY MISSPELLED c3p0-conf.xml RESOURCE FOUND. Please ensure the file name is c3p0-config.xml, all lower case, with the digit 0 (NOT the letter O) in c3p0. It should be placed  in the top level of c3p0's effective classpath.");
                            return;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static C3P0Config extractXmlConfigFromDefaultResource() throws Exception {
        InputStream is = null;
        try {
            is = C3P0ConfigUtils.class.getResourceAsStream(XML_CONFIG_RSRC_PATH);
            if (is == null) {
                C3P0ConfigXmlUtils.warnCommonXmlConfigResourceMisspellings();
                C3P0Config c3P0Config = null;
                return c3P0Config;
            }
            C3P0Config c3P0Config = C3P0ConfigXmlUtils.extractXmlConfigFromInputStream(is);
            return c3P0Config;
        }
        finally {
            block12: {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e2) {
                    if (!logger.isLoggable(MLevel.FINE)) break block12;
                    logger.log(MLevel.FINE, "Exception on resource InputStream close.", e2);
                }
            }
        }
    }

    public static C3P0Config extractXmlConfigFromInputStream(InputStream is) throws Exception {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = fact.newDocumentBuilder();
        Document doc = db.parse(is);
        return C3P0ConfigXmlUtils.extractConfigFromXmlDoc(doc);
    }

    public static C3P0Config extractConfigFromXmlDoc(Document doc) throws Exception {
        Element docElem = doc.getDocumentElement();
        if (docElem.getTagName().equals("c3p0-config")) {
            HashMap<String, NamedScope> configNamesToNamedScopes = new HashMap<String, NamedScope>();
            Element defaultConfigElem = DomParseUtils.uniqueChild(docElem, "default-config");
            NamedScope defaults = defaultConfigElem != null ? C3P0ConfigXmlUtils.extractNamedScopeFromLevel(defaultConfigElem) : new NamedScope();
            NodeList nl = DomParseUtils.immediateChildElementsByTagName(docElem, "named-config");
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Element namedConfigElem = (Element)nl.item(i);
                String configName = namedConfigElem.getAttribute("name");
                if (configName != null && configName.length() > 0) {
                    NamedScope namedConfig = C3P0ConfigXmlUtils.extractNamedScopeFromLevel(namedConfigElem);
                    configNamesToNamedScopes.put(configName, namedConfig);
                    continue;
                }
                logger.warning("Configuration XML contained named-config element without name attribute: " + namedConfigElem);
            }
            return new C3P0Config(defaults, configNamesToNamedScopes);
        }
        throw new Exception("Root element of c3p0 config xml should be 'c3p0-config', not '" + docElem.getTagName() + "'.");
    }

    private static NamedScope extractNamedScopeFromLevel(Element elem) {
        HashMap props = C3P0ConfigXmlUtils.extractPropertiesFromLevel(elem);
        HashMap<String, HashMap> userNamesToOverrides = new HashMap<String, HashMap>();
        NodeList nl = DomParseUtils.immediateChildElementsByTagName(elem, "user-overrides");
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element perUserConfigElem = (Element)nl.item(i);
            String userName = perUserConfigElem.getAttribute("user");
            if (userName != null && userName.length() > 0) {
                HashMap userProps = C3P0ConfigXmlUtils.extractPropertiesFromLevel(perUserConfigElem);
                userNamesToOverrides.put(userName, userProps);
                continue;
            }
            logger.warning("Configuration XML contained user-overrides element without user attribute: " + LINESEP + perUserConfigElem);
        }
        return new NamedScope(props, userNamesToOverrides);
    }

    private static HashMap extractPropertiesFromLevel(Element elem) {
        HashMap<String, String> out = new HashMap<String, String>();
        try {
            NodeList nl = DomParseUtils.immediateChildElementsByTagName(elem, "property");
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Element propertyElem = (Element)nl.item(i);
                String propName = propertyElem.getAttribute("name");
                if (propName != null && propName.length() > 0) {
                    String propVal = DomParseUtils.allTextFromElement(propertyElem, true);
                    out.put(propName, propVal);
                    continue;
                }
                logger.warning("Configuration XML contained property element without name attribute: " + LINESEP + propertyElem);
            }
        }
        catch (Exception e2) {
            logger.log(MLevel.WARNING, "An exception occurred while reading config XML. Some configuration information has probably been ignored.", e2);
        }
        return out;
    }

    private C3P0ConfigXmlUtils() {
    }

    static {
        String ls;
        logger = MLog.getLogger(C3P0ConfigXmlUtils.class);
        MISSPELL_PFXS = new String[]{"/c3p0", "/c3pO", "/c3po", "/C3P0", "/C3PO"};
        MISSPELL_LINES = new char[]{'-', '_'};
        MISSPELL_CONFIG = new String[]{"config", "CONFIG"};
        MISSPELL_XML = new String[]{"xml", "XML"};
        try {
            ls = System.getProperty("line.separator", "\r\n");
        }
        catch (Exception e2) {
            ls = "\r\n";
        }
        LINESEP = ls;
    }
}

