/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Zeta
extends AbstractDiscreteDistribution {
    protected double ro;
    protected double pk;
    protected double c;
    protected double d;
    protected double ro_prev = -1.0;
    protected double pk_prev = -1.0;
    protected double maxlongint = 9.223372036854776E18;
    protected static Zeta shared = new Zeta(1.0, 1.0, AbstractDistribution.makeDefaultGenerator());

    public Zeta(double d2, double d3, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2, d3);
    }

    protected long generateZeta(double d2, double d3, RandomElement randomElement) {
        long l;
        if (d2 != this.ro_prev || d3 != this.pk_prev) {
            this.ro_prev = d2;
            this.pk_prev = d3;
            if (d2 < d3) {
                this.c = d3 - 0.5;
                this.d = 0.0;
            } else {
                this.c = d2 - 0.5;
                this.d = (1.0 + d2) * Math.log((1.0 + d3) / (1.0 + d2));
            }
        }
        while (true) {
            double d4 = randomElement.raw();
            double d5 = randomElement.raw();
            double d6 = (this.c + 0.5) * Math.exp(-Math.log(d4) / d2) - this.c;
            if (d6 <= 0.5 || d6 >= this.maxlongint) continue;
            l = (int)(d6 + 0.5);
            double d7 = -Math.log(d5);
            if (!(d7 < (1.0 + d2) * Math.log(((double)l + d3) / (d6 + this.c)) - this.d)) break;
        }
        return l;
    }

    public int nextInt() {
        return (int)this.generateZeta(this.ro, this.pk, this.randomGenerator);
    }

    public void setState(double d2, double d3) {
        this.ro = d2;
        this.pk = d3;
    }

    public static int staticNextInt(double d2, double d3) {
        Zeta zeta = shared;
        synchronized (zeta) {
            shared.setState(d2, d3);
            int n = shared.nextInt();
            return n;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.ro + "," + this.pk + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Zeta zeta = shared;
        synchronized (zeta) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

