# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the Timestamp message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class Timestamp < Message
      ##
      # Represents seconds of UTC time since Unix epoch
      #  1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
      #  9999-12-31T23:59:59Z inclusive.
      ##
      attr_reader :seconds

      ##
      # Non-negative fractions of a second at nanosecond resolution. Negative
      #  second values with fractions must still have non-negative nanos values
      #  that count forward in time. Must be from 0 to 999,999,999
      #  inclusive.
      ##
      attr_reader :nanos

      def initialize(
        seconds: 0,
        nanos: 0
      )
        @seconds = seconds
        @nanos = nanos
        super()
      end

      ##
      # Returns a new Timestamp from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::Timestamp.from_h(some_hash) # => #<Cucumber::Messages::Timestamp:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          seconds: hash[:seconds],
          nanos: hash[:nanos]
        )
      end
    end
  end
end
