/***************************************************************************
 *   Copyright (C) 2004 by EVER Sp. z o.o.                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CONF_H
#define CONF_H
 
#include <iostream>
#include <cstdlib>
#include <list>

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

using namespace std;

#define CONF_SUCCESS	( 0)
#define CONF_FAILURE	(-1)

/* error codes */
#define CONF_ERR_GENERIC_DESC				"Unspecified error"
#define CONF_ERR_FILEOPEN			(-100)	// couldn't open file.
#define CONF_ERR_FILEOPEN_DESC			"File open error"
#define CONF_ERR_NOTHINGTOPARSE	(-101)	// the file is empty or it's entire content is commented out.
#define CONF_ERR_NOTHINGTOPARSE_DESC	"There is no data to parse in the config file"
#define CONF_ERR_INVALIDFORMAT	(-102)	// the format of file is invalid (eg. var without a value).
#define CONF_ERR_INVALIDFORMAT_DESC		"Format of file is not valid"
#define CONF_ERR_MEMALLOC			(-103)	// not enough memory
#define CONF_ERR_MEMALLOC_DESC			"Not enough memory"
#define CONF_ERR_LINETOOLONG		(-104)	// line in config file is too long (>1024)
#define CONF_ERR_LINETOOLONG_DESC		"Some line in the config file is too long (>1024 characters)"
#define CONF_ERR_INVALIDDATA		(-105)	// input data is not valid
#define CONF_ERR_INVALIDDATA_DESC		"Specified input data is not valid"

// config item, structure
typedef struct _CItem {
	char *name;
	char *value;
} CItem;

// config handling class
class CConf
{
private:
	char *lpConfFile;
	int	iErrorCode;
	list<CItem*>	pci;

	int read_line(FILE *lpf, char **lb);
	int parse_line(char *line);
	void cleanup_text(char **line);
	
public:
	/* class constructor & destructor */
	CConf() {
		lpConfFile=NULL;
		iErrorCode=0;
	};
	CConf(char *fp) {
		lpConfFile = strdup(fp);
		if (!lpConfFile) {
			iErrorCode=CONF_ERR_INVALIDDATA;
			return;
		}
		FILE *ftest;
		if ((ftest=fopen(lpConfFile, "r"))==NULL) {
			iErrorCode=CONF_ERR_FILEOPEN;
			return;
		} else
			fclose(ftest);
		parse_config();
	};
	~CConf() {
		if (lpConfFile!=NULL)
			free(lpConfFile);
		while (!pci.empty()) {
			free(((CItem*)(pci.back())->name));
			free(((CItem*)(pci.back())->value));
			delete ((CItem*)pci.back());
      	pci.pop_back();
		}
		pci.clear();
	};
	
	int init(char *lpfilename) {
		lpConfFile = strdup(lpfilename);
		if (!lpConfFile) {
			iErrorCode=CONF_ERR_INVALIDDATA;
			return CONF_FAILURE;
		}
		FILE *ftest;
		if ((ftest=fopen(lpfilename, "r"))==NULL) {
			iErrorCode=CONF_ERR_FILEOPEN;
			return CONF_FAILURE;
		} else
			fclose(ftest);
		return CONF_SUCCESS;
	};
	
	char *geterrordesc();
	int parse_config();
	bool is_comment(char *line);
	char *getcfgitemvalue(char *name);
};

#endif/*CONF_H*/
