/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tim.prune.data.Timestamp;

public class TimestampUtc
extends Timestamp {
    private final boolean _valid;
    private final long _milliseconds;
    private final String _text;
    private static final DateFormat ISO_8601_FORMAT_NOZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static DateFormat[] ALL_DATE_FORMATS = null;
    private static Calendar CALENDAR = null;
    private static final Pattern ISO8601_FRACTIONAL_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2})(?:[.,](\\d{1,3}))?(Z|[+-]\\d{2}(?::?\\d{2})?)?");
    private static final Pattern GENERAL_TIMESTAMP_PATTERN = Pattern.compile("(\\d{4})\\D(\\d{2})\\D(\\d{2})\\D(\\d{2})\\D(\\d{2})\\D(\\d{2})");
    private static long SECS_SINCE_1970 = 0L;
    private static long SECS_SINCE_GARTRIP = 0L;
    private static long MSECS_SINCE_1970 = 0L;
    private static long MSECS_SINCE_1990 = 0L;
    private static long TWENTY_YEARS_IN_SECS = 0L;
    private static final long GARTRIP_OFFSET = 631065600L;
    private static final ParseType[] ALL_PARSE_TYPES = new ParseType[]{ParseType.NONE, ParseType.ISO8601_FRACTIONAL, ParseType.LONG, ParseType.FIXED_FORMAT0, ParseType.FIXED_FORMAT1, ParseType.FIXED_FORMAT2, ParseType.FIXED_FORMAT3, ParseType.FIXED_FORMAT4, ParseType.FIXED_FORMAT5, ParseType.FIXED_FORMAT6, ParseType.FIXED_FORMAT7, ParseType.FIXED_FORMAT8, ParseType.GENERAL_STRING};

    static {
        CALENDAR = Calendar.getInstance();
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        CALENDAR.setTimeZone(timeZone);
        MSECS_SINCE_1970 = CALENDAR.getTimeInMillis();
        SECS_SINCE_1970 = MSECS_SINCE_1970 / 1000L;
        SECS_SINCE_GARTRIP = SECS_SINCE_1970 - 631065600L;
        CALENDAR.add(1, -20);
        MSECS_SINCE_1990 = CALENDAR.getTimeInMillis();
        TWENTY_YEARS_IN_SECS = (MSECS_SINCE_1970 - MSECS_SINCE_1990) / 1000L;
        DateFormat[] dateFormatArray = ALL_DATE_FORMATS = new DateFormat[]{DEFAULT_DATETIME_FORMAT, new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy"), new SimpleDateFormat("HH:mm:ss dd MMM yyyy"), new SimpleDateFormat("dd MMM yyyy HH:mm:ss"), new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss"), new SimpleDateFormat("yyyy MMM dd HH:mm:ss"), new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aa"), ISO_8601_FORMAT, ISO_8601_FORMAT_NOZ};
        int n = ALL_DATE_FORMATS.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat dateFormat = dateFormatArray[n2];
            dateFormat.setLenient(false);
            dateFormat.setTimeZone(timeZone);
            ++n2;
        }
    }

    public TimestampUtc(String string) {
        String string2 = null;
        long l = 0L;
        if (string != null && !string.equals("")) {
            ParseType[] parseTypeArray = ALL_PARSE_TYPES;
            int n = ALL_PARSE_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                ParseType parseType = parseTypeArray[n2];
                Long l2 = TimestampUtc.parseString(string, parseType);
                if (l2 != null) {
                    TimestampUtc.ALL_PARSE_TYPES[0] = parseType;
                    string2 = string;
                    l = l2;
                    break;
                }
                ++n2;
            }
        }
        this._text = string2;
        this._milliseconds = l;
        this._valid = this._text != null;
    }

    private static Long parseString(String string, ParseType parseType) {
        if (string == null || string.equals("")) {
            return null;
        }
        switch (parseType) {
            case NONE: {
                return null;
            }
            case LONG: {
                try {
                    long l = Long.parseLong(string.trim());
                    return TimestampUtc.getMilliseconds(l);
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            case ISO8601_FRACTIONAL: {
                Matcher matcher = ISO8601_FRACTIONAL_PATTERN.matcher(string);
                if (!matcher.matches()) break;
                try {
                    return TimestampUtc.getMilliseconds(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), matcher.group(7), matcher.group(8));
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            case FIXED_FORMAT0: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[0]);
            }
            case FIXED_FORMAT1: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[1]);
            }
            case FIXED_FORMAT2: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[2]);
            }
            case FIXED_FORMAT3: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[3]);
            }
            case FIXED_FORMAT4: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[4]);
            }
            case FIXED_FORMAT5: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[5]);
            }
            case FIXED_FORMAT6: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[6]);
            }
            case FIXED_FORMAT7: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[7]);
            }
            case FIXED_FORMAT8: {
                return TimestampUtc.parseString(string, ALL_DATE_FORMATS[8]);
            }
            case GENERAL_STRING: {
                Matcher matcher;
                if (string.length() != 19 || !(matcher = GENERAL_TIMESTAMP_PATTERN.matcher(string)).matches()) break;
                try {
                    return TimestampUtc.getMilliseconds(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)), Integer.parseInt(matcher.group(6)), null, null);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return null;
    }

    private static Long parseString(String string, DateFormat dateFormat) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = dateFormat.parse(string, parsePosition);
        if (date != null && string.length() == parsePosition.getIndex()) {
            CALENDAR.setTime(date);
            return CALENDAR.getTimeInMillis();
        }
        return null;
    }

    public TimestampUtc(long l) {
        this._milliseconds = l;
        this._text = null;
        this._valid = true;
    }

    private static long getMilliseconds(int n, int n2, int n3, int n4, int n5, int n6, String string, String string2) {
        Calendar calendar = Calendar.getInstance();
        if (string2 == null || string2.equals("") || string2.equals("Z")) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        } else {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT" + string2));
        }
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        int n7 = 0;
        if (string != null) {
            try {
                int n8 = Integer.parseInt(string);
                int n9 = string.length();
                switch (n9) {
                    case 1: {
                        n7 = n8 * 100;
                        break;
                    }
                    case 2: {
                        n7 = n8 * 10;
                        break;
                    }
                    case 3: {
                        n7 = n8;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        calendar.set(14, n7);
        return calendar.getTimeInMillis();
    }

    private static long getMilliseconds(long l) {
        long l2 = Math.abs(SECS_SINCE_1970 - l);
        long l3 = Math.abs(MSECS_SINCE_1970 - l);
        long l4 = Math.abs(MSECS_SINCE_1990 - l);
        long l5 = Math.abs(SECS_SINCE_GARTRIP - l);
        long l6 = l2;
        long l7 = l * 1000L;
        if (l3 < l6) {
            l7 = l;
            l6 = l3;
        }
        if (l4 < l6) {
            l7 = l + TWENTY_YEARS_IN_SECS * 1000L;
            l6 = l4;
        }
        if (l5 < l6) {
            l7 = (l + 631065600L) * 1000L;
        }
        return l7;
    }

    @Override
    public boolean isValid() {
        return this._valid;
    }

    @Override
    protected boolean hasMilliseconds() {
        return this.isValid() && this._milliseconds % 1000L > 0L;
    }

    @Override
    public long getMilliseconds(TimeZone timeZone) {
        return this._milliseconds;
    }

    @Override
    public Timestamp addOffsetSeconds(long l) {
        return new TimestampUtc(this._milliseconds + l * 1000L);
    }

    @Override
    public String getText(Timestamp.Format format, TimeZone timeZone) {
        if (this.isValid() && this._text != null && format == Timestamp.Format.ORIGINAL) {
            return this._text;
        }
        return super.getText(format, timeZone);
    }

    @Override
    protected String format(DateFormat dateFormat, TimeZone timeZone) {
        CALENDAR.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormat.setTimeZone(timeZone == null ? TimeZone.getTimeZone("GMT") : timeZone);
        CALENDAR.setTimeInMillis(this._milliseconds);
        return dateFormat.format(CALENDAR.getTime());
    }

    @Override
    public Calendar getCalendar(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTimeInMillis(this._milliseconds);
        return calendar;
    }

    private static enum ParseType {
        NONE,
        ISO8601_FRACTIONAL,
        LONG,
        FIXED_FORMAT0,
        FIXED_FORMAT1,
        FIXED_FORMAT2,
        FIXED_FORMAT3,
        FIXED_FORMAT4,
        FIXED_FORMAT5,
        FIXED_FORMAT6,
        FIXED_FORMAT7,
        FIXED_FORMAT8,
        GENERAL_STRING;

    }
}

