package io.cucumber.cucumberexpressions;

import org.junit.jupiter.api.Test;

import java.util.List;
import java.util.Locale;

import static java.util.Collections.singletonList;
import static org.junit.jupiter.api.Assertions.assertEquals;

public class ArgumentTest {
    @Test
    public void exposes_parameter_type() {
        TreeRegexp treeRegexp = new TreeRegexp("three (.*) mice");
        ParameterTypeRegistry parameterTypeRegistry = new ParameterTypeRegistry(Locale.ENGLISH);
        List<Argument<?>> arguments = Argument.build(
                treeRegexp.match("three blind mice"),
                singletonList(parameterTypeRegistry.lookupByTypeName("string")));
        Argument<?> argument = arguments.get(0);
        assertEquals("string", argument.getParameterType().getName());
    }

}
