// scale_album_art_runnable.h
//
// Project: Ampache Browser
// License: GNU GPLv3
//
// Copyright (C) 2015 - 2024 Róbert Čerňanský



#ifndef SCALEALBUMARTRUNNABLE_H
#define SCALEALBUMARTRUNNABLE_H



#include <string>

#include <QByteArray>
#include <QObject>
#include <QRunnable>
#include <QImage>



namespace data {

/**
 * @brief Scales the given image to a predefined size.
 *
 * Intended to run asynchronously using the QT threading support.
 */
class ScaleAlbumArtRunnable: public QObject, public QRunnable {
    Q_OBJECT

signals:
    void finished(ScaleAlbumArtRunnable* scaleAlbumArtRunnable);

public:
    /**
     * @brief Constructor.
     *
     * @param id Identifier of the scaled image.
     * @param imageData The image which shall be scaled.
     * @param size Number of pixels the image shall be scaled to.
     */
    explicit ScaleAlbumArtRunnable(const std::string id, const QByteArray imageData, int size);

    /**
     * @brief Gets the identifier of the scaled image (which was passed to the constructor).
     *
     * @return std::string.
     */
    std::string getId() const;

    /**
     * @brief Gets the scaled image.
     *
     * @return QImage
     */
    QImage getResult() const;

private:
    // arguments from the constructor
    const std::string myId;
    const QByteArray myImageData;
    const int mySize = 0;

    // scaled image
    QImage myScaledAlbumArt;

    void run() override;
};

}



#endif // SCALEALBUMARTRUNNABLE_H
