/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.blame;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class SvnBlameConsumer
extends AbstractConsumer {
    private static final String SVN_TIMESTAMP_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String LINE_PATTERN = "line-number=\"(.*)\"";
    private static final String REVISION_PATTERN = "revision=\"(.*)\"";
    private static final String AUTHOR_PATTERN = "<author>(.*)</author>";
    private static final String DATE_PATTERN = "<date>(.*)T(.*)\\.(.*)Z</date>";
    private RE lineRegexp;
    private RE revisionRegexp;
    private RE authorRegexp;
    private RE dateRegexp;
    private SimpleDateFormat dateFormat;
    private List lines = new ArrayList();
    private int lineNumber;
    private String revision;
    private String author;

    public SvnBlameConsumer(ScmLogger logger) {
        super(logger);
        this.dateFormat = new SimpleDateFormat(SVN_TIMESTAMP_PATTERN);
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.lineRegexp = new RE(LINE_PATTERN);
            this.revisionRegexp = new RE(REVISION_PATTERN);
            this.authorRegexp = new RE(AUTHOR_PATTERN);
            this.dateRegexp = new RE(DATE_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public void consumeLine(String line) {
        if (this.lineRegexp.match(line)) {
            String lineNumberStr = this.lineRegexp.getParen(1);
            this.lineNumber = Integer.parseInt(lineNumberStr);
        } else if (this.revisionRegexp.match(line)) {
            this.revision = this.revisionRegexp.getParen(1);
        } else if (this.authorRegexp.match(line)) {
            this.author = this.authorRegexp.getParen(1);
        } else if (this.dateRegexp.match(line)) {
            String date = this.dateRegexp.getParen(1);
            String time = this.dateRegexp.getParen(2);
            Date dateTime = this.parseDateTime(date + " " + time);
            this.getLines().add(new BlameLine(dateTime, this.revision, this.author));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Author of line " + this.lineNumber + ": " + this.author + " (" + date + ")");
            }
        }
    }

    protected Date parseDateTime(String dateTimeStr) {
        try {
            return this.dateFormat.parse(dateTimeStr);
        }
        catch (ParseException e) {
            this.getLogger().error("skip ParseException: " + e.getMessage() + " during parsing date " + dateTimeStr, e);
            return null;
        }
    }

    public List getLines() {
        return this.lines;
    }
}

