/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.pms.PMS;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.formats.v2.SubtitleType;
import net.pms.util.Iso639;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);
    private static Map<File, File[]> cache;
    private static final String DEFAULT_BASENAME = "NO_DEFAULT_BASENAME_SUPPLIED.conf";

    private FileUtil() {
    }

    public static FileLocation getFileLocation(String customPath, String defaultDirectory, String defaultBasename) {
        File customFile = null;
        File directory = null;
        File file = null;
        if (StringUtils.isBlank(defaultBasename)) {
            defaultBasename = DEFAULT_BASENAME;
        }
        if (defaultDirectory == null) {
            defaultDirectory = "";
        }
        if (customPath != null) {
            customFile = new File(customPath).getAbsoluteFile();
        }
        if (customFile != null) {
            if (customFile.exists()) {
                if (customFile.isDirectory()) {
                    directory = customFile;
                    file = new File(customFile, defaultBasename).getAbsoluteFile();
                } else {
                    directory = customFile.getParentFile();
                    file = customFile;
                }
            } else {
                File parentDirectoryFile = customFile.getParentFile();
                if (parentDirectoryFile != null && parentDirectoryFile.exists()) {
                    directory = parentDirectoryFile;
                    file = customFile;
                }
            }
        }
        if (directory == null || file == null) {
            directory = new File(defaultDirectory).getAbsoluteFile();
            file = new File(directory, defaultBasename).getAbsoluteFile();
        }
        return new FileLocation(directory, file);
    }

    public static File isFileExists(String f, String ext) {
        return FileUtil.isFileExists(new File(f), ext);
    }

    public static String getProtocol(String filename) {
        String protocol = null;
        if (filename != null) {
            try {
                URI uri = new URI(filename.toLowerCase());
                protocol = uri.getScheme();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return protocol;
    }

    @Deprecated
    public static String getExtension(String filePath) {
        return FilenameUtils.getExtension(filePath);
    }

    @Deprecated
    public static String getFileNameWithoutExtension(String filePath) {
        return FilenameUtils.getBaseName(filePath);
    }

    public static String getFileNameWithRewriting(String f) {
        int point = f.lastIndexOf(".");
        if (point == -1) {
            point = f.length();
        }
        String formattedName = f.substring(0, point);
        String commonFileEnds = "[\\s\\.]AC3.*|[\\s\\.]REPACK.*|[\\s\\.]480p.*|[\\s\\.]720p.*|[\\s\\.]m-720p.*|[\\s\\.]900p.*|[\\s\\.]1080p.*|[\\s\\.]HDTV.*|[\\s\\.]DSR.*|[\\s\\.]PDTV.*|[\\s\\.]WS.*|[\\s\\.]HQ.*|[\\s\\.]DVDRip.*|[\\s\\.]TVRiP.*|[\\s\\.]BDRip.*|[\\s\\.]BluRay.*|[\\s\\.]SUBBED.*|[\\s\\.]x264.*|[\\s\\.]Dual[\\s\\.]Audio.*|[\\s\\.]HSBS.*|[\\s\\.]H-SBS.*";
        String commonFileEndsMatch = ".*[\\s\\.]AC3.*|.*[\\s\\.]REPACK.*|.*[\\s\\.]480p.*|.*[\\s\\.]720p.*|.*[\\s\\.]m-720p.*|.*[\\s\\.]900p.*|.*[\\s\\.]1080p.*|.*[\\s\\.]HDTV.*|.*[\\s\\.]DSR.*|.*[\\s\\.]PDTV.*|.*[\\s\\.]WS.*|.*[\\s\\.]HQ.*|.*[\\s\\.]DVDRip.*|.*[\\s\\.]TVRiP.*|.*[\\s\\.]BDRip.*|.*[\\s\\.]BluRay.*|.*[\\s\\.]SUBBED.*|.*[\\s\\.]x264.*|.*[\\s\\.]Dual[\\s\\.]Audio.*|.*[\\s\\.]HSBS.*|.*[\\s\\.]H-SBS.*";
        String commonFileEndsCaseSensitive = "[\\s\\.]PROPER.*|[\\s\\.]iNTERNAL.*|[\\s\\.]LIMITED.*|[\\s\\.]FESTiVAL.*|[\\s\\.]NORDIC.*";
        if (formattedName.matches(".*[sS]0\\d[eE]\\d\\d.*")) {
            formattedName = formattedName.replaceAll("(?i)[\\s\\.]S0(\\d)E(\\d)(\\d)(" + commonFileEnds + ")", " - $1$2$3");
            formattedName = formattedName.replaceAll("(?i)[\\s\\.]S0(\\d)E(\\d)(\\d)[\\s\\.]", " - $1$2$3 - ");
            formattedName = formattedName.replaceAll("(?i)" + commonFileEnds, "");
            formattedName = formattedName.replaceAll(commonFileEndsCaseSensitive, "");
            formattedName = formattedName.replaceAll("\\.", " ");
        } else if (formattedName.matches(".*[sS][1-9]\\d[eE]\\d\\d.*")) {
            formattedName = formattedName.replaceAll("(?i)[\\s\\.]S([1-9]\\d)E(\\d)(\\d)(" + commonFileEnds + ")", " - $1$2$3");
            formattedName = formattedName.replaceAll("(?i)[\\s\\.]S([1-9]\\d)E(\\d)(\\d)[\\s\\.]", " - $1$2$3 - ");
            formattedName = formattedName.replaceAll("(?i)" + commonFileEnds, "");
            formattedName = formattedName.replaceAll(commonFileEndsCaseSensitive, "");
            formattedName = formattedName.replaceAll("\\.", " ");
        } else if (formattedName.matches(".*\\.(19|20)\\d\\d\\.[0-1]\\d\\.[0-3]\\d\\..*")) {
            formattedName = formattedName.replaceAll("(?i)\\.(19|20)(\\d\\d)\\.([0-1]\\d)\\.([0-3]\\d)(" + commonFileEnds + ")", " - $1$2/$3/$4");
            formattedName = formattedName.replaceAll("(?i)\\.(19|20)(\\d\\d)\\.([0-1]\\d)\\.([0-3]\\d)\\.", " - $1$2/$3/$4 - ");
            formattedName = formattedName.replaceAll("(?i)" + commonFileEnds, "");
            formattedName = formattedName.replaceAll(commonFileEndsCaseSensitive, "");
            formattedName = formattedName.replaceAll("\\.", " ");
        } else if (formattedName.matches(".*\\.(19|20)\\d\\d\\..*")) {
            formattedName = formattedName.replaceAll("\\.(19|20)(\\d\\d)", " ($1$2)");
            formattedName = formattedName.replaceAll("(?i)" + commonFileEnds, "");
            formattedName = formattedName.replaceAll(commonFileEndsCaseSensitive, "");
            formattedName = formattedName.replaceAll("(?i)\\.(CD[1-3])\\.|\\.(3D)\\.|\\.(Special.Edition)\\.|\\.(Unrated)\\.|\\.(Final.Cut)\\.|\\.(Remastered)\\.|\\.(Extended.Cut)\\.", " ($1)");
            formattedName = formattedName.replaceAll("\\.", " ");
        } else if (formattedName.matches(commonFileEndsMatch)) {
            formattedName = formattedName.replaceAll("(?i)" + commonFileEnds, "");
            formattedName = formattedName.replaceAll(commonFileEndsCaseSensitive, "");
            formattedName = formattedName.replaceAll("(?i)\\.(CD[1-3])\\.|\\.(3D)\\.|\\.(Special.Edition)\\.|\\.(Unrated)\\.|\\.(Final.Cut)\\.|\\.(Remastered)\\.|\\.(Extended.Cut)\\.", " ($1)");
            formattedName = formattedName.replaceAll("\\.", " ");
        } else if (formattedName.matches(".*\\[(19|20)\\d\\d\\].*")) {
            formattedName = formattedName.replaceAll("(?i)\\[(19|20)(\\d\\d)\\].*", " ($1$2)");
            formattedName = formattedName.replaceAll("\\.", " ");
        } else if (formattedName.matches(".*\\((19|20)\\d\\d\\).*")) {
            formattedName = formattedName.replaceAll("(?i)" + commonFileEnds, "");
            formattedName = formattedName.replaceAll(commonFileEndsCaseSensitive, "");
        } else if (formattedName.matches(".*\\((19|20)\\d\\d\\).*")) {
            formattedName = formattedName.replaceAll("(?i)" + commonFileEnds, "");
            formattedName = formattedName.replaceAll(commonFileEndsCaseSensitive, "");
        } else if (formattedName.matches(".*\\[[0-9a-zA-Z]{8}\\]$")) {
            formattedName = formattedName.replaceAll("_", " ");
            if ((formattedName = formattedName.replaceAll("(?i)\\s\\(1280x720.*|\\s\\(1920x1080.*|\\s\\(720x400.*|\\[720p.*|\\[1080p.*|\\[480p.*|\\s\\(BD.*|\\s\\[Blu-Ray.*|\\s\\[DVD.*|\\.DVD.*|\\[[0-9a-zA-Z]{8}\\]$|\\[h264.*|R1DVD.*|\\[BD.*", "")).substring(0, 1).matches("\\[")) {
                int closingBracketIndex = formattedName.indexOf("]");
                if (closingBracketIndex != -1) {
                    formattedName = formattedName.substring(closingBracketIndex + 1);
                }
                if (formattedName.substring(0, 1).matches("\\s")) {
                    formattedName = formattedName.substring(1);
                }
            }
        } else if (formattedName.matches(".*\\[BD\\].*|.*\\[720p\\].*|.*\\[1080p\\].*|.*\\[480p\\].*|.*\\[Blu-Ray.*|.*\\[h264.*")) {
            formattedName = formattedName.replaceAll("_", " ");
            if ((formattedName = formattedName.replaceAll("(?i)\\[BD\\].*|\\[720p.*|\\[1080p.*|\\[480p.*|\\[Blu-Ray.*\\[h264.*", "")).substring(0, 1).matches("\\[")) {
                int closingBracketIndex = formattedName.indexOf("]");
                if (closingBracketIndex != -1) {
                    formattedName = formattedName.substring(closingBracketIndex + 1);
                }
                if (formattedName.substring(0, 1).matches("\\s")) {
                    formattedName = formattedName.substring(1);
                }
            }
        }
        return formattedName;
    }

    public static File getFileNameWithNewExtension(File parent, File file, String ext) {
        return FileUtil.isFileExists(new File(parent, file.getName()), ext);
    }

    @Deprecated
    public static File getFileNameWitNewExtension(File parent, File f, String ext) {
        return FileUtil.getFileNameWithNewExtension(parent, f, ext);
    }

    public static File getFileNameWithAddedExtension(File parent, File f, String ext) {
        File ff = new File(parent, f.getName() + ext);
        if (ff.exists()) {
            return ff;
        }
        return null;
    }

    @Deprecated
    public static File getFileNameWitAddedExtension(File parent, File file, String ext) {
        return FileUtil.getFileNameWithAddedExtension(parent, file, ext);
    }

    public static File isFileExists(File f, String ext) {
        File lowerCasedFile;
        int point = f.getName().lastIndexOf(".");
        if (point == -1) {
            point = f.getName().length();
        }
        if ((lowerCasedFile = new File(f.getParentFile(), f.getName().substring(0, point) + "." + ext.toLowerCase())).exists()) {
            return lowerCasedFile;
        }
        File upperCasedFile = new File(f.getParentFile(), f.getName().substring(0, point) + "." + ext.toUpperCase());
        if (upperCasedFile.exists()) {
            return upperCasedFile;
        }
        return null;
    }

    @Deprecated
    public static boolean doesSubtitlesExists(File file, DLNAMediaInfo media) {
        return FileUtil.isSubtitlesExists(file, media);
    }

    public static boolean isSubtitlesExists(File file, DLNAMediaInfo media) {
        return FileUtil.isSubtitlesExists(file, media, true);
    }

    @Deprecated
    public static boolean doesSubtitlesExists(File file, DLNAMediaInfo media, boolean usecache) {
        return FileUtil.isSubtitlesExists(file, media, usecache);
    }

    public static boolean isSubtitlesExists(File file, DLNAMediaInfo media, boolean usecache) {
        boolean found = FileUtil.browseFolderForSubtitles(file.getParentFile(), file, media, usecache);
        String alternate = PMS.getConfiguration().getAlternateSubtitlesFolder();
        if (StringUtils.isNotBlank(alternate)) {
            File subFolder = new File(alternate);
            if (!subFolder.isAbsolute()) {
                subFolder = new File(file.getParent() + "/" + alternate);
                try {
                    subFolder = subFolder.getCanonicalFile();
                }
                catch (IOException e) {
                    logger.debug("Caught exception", e);
                }
            }
            if (subFolder.exists()) {
                found = found || FileUtil.browseFolderForSubtitles(subFolder, file, media, usecache);
            }
        }
        return found;
    }

    private static synchronized boolean browseFolderForSubtitles(File subFolder, File file, DLNAMediaInfo media, boolean usecache) {
        File[] allSubs;
        boolean found = false;
        if (!usecache) {
            cache = null;
        }
        if (cache == null) {
            cache = new HashMap<File, File[]>();
        }
        if ((allSubs = cache.get(subFolder)) == null && (allSubs = subFolder.listFiles()) != null) {
            cache.put(subFolder, allSubs);
        }
        String fileName = FilenameUtils.getBaseName(file.getName()).toLowerCase();
        if (allSubs != null) {
            for (File f : allSubs) {
                if (!f.isFile() || f.isHidden()) continue;
                String fName = f.getName().toLowerCase();
                for (String ext : SubtitleType.getSupportedFileExtensions()) {
                    if (fName.length() <= ext.length() || !fName.startsWith(fileName) || !org.apache.commons.lang3.StringUtils.endsWithIgnoreCase(fName, "." + ext)) continue;
                    int a = fileName.length();
                    int b = fName.length() - ext.length() - 1;
                    String code = "";
                    if (a <= b) {
                        code = fName.substring(a, b);
                    }
                    if (code.startsWith(".")) {
                        code = code.substring(1);
                    }
                    boolean exists = false;
                    if (media != null) {
                        for (DLNAMediaSubtitle sub : media.getSubtitleTracksList()) {
                            if (f.equals(sub.getExternalFile())) {
                                exists = true;
                                continue;
                            }
                            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase(ext, "idx") && sub.getType() == SubtitleType.MICRODVD) {
                                sub.setType(SubtitleType.VOBSUB);
                                exists = true;
                                continue;
                            }
                            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase(ext, "sub") || sub.getType() != SubtitleType.VOBSUB) continue;
                            try {
                                sub.setExternalFile(f);
                            }
                            catch (FileNotFoundException ex) {
                                logger.warn("Exception during external subtitles scan.", ex);
                            }
                            exists = true;
                        }
                    }
                    if (exists) continue;
                    DLNAMediaSubtitle sub = new DLNAMediaSubtitle();
                    sub.setId(100 + (media == null ? 0 : media.getSubtitleTracksList().size()));
                    if (code.length() == 0 || !Iso639.getCodeList().contains(code)) {
                        sub.setLang("und");
                        sub.setType(SubtitleType.valueOfFileExtension(ext));
                        if (code.length() > 0) {
                            sub.setFlavor(code);
                            if (sub.getFlavor().contains("-")) {
                                String flavorLang = sub.getFlavor().substring(0, sub.getFlavor().indexOf("-"));
                                String flavorTitle = sub.getFlavor().substring(sub.getFlavor().indexOf("-") + 1);
                                if (Iso639.getCodeList().contains(flavorLang)) {
                                    sub.setLang(flavorLang);
                                    sub.setFlavor(flavorTitle);
                                }
                            }
                        }
                    } else {
                        sub.setLang(code);
                        sub.setType(SubtitleType.valueOfFileExtension(ext));
                    }
                    try {
                        sub.setExternalFile(f);
                    }
                    catch (FileNotFoundException ex) {
                        logger.warn("Exception during external subtitles scan.", ex);
                    }
                    found = true;
                    if (media == null) continue;
                    media.getSubtitleTracksList().add(sub);
                }
            }
        }
        return found;
    }

    public static String getFileCharset(File file) throws IOException {
        int numberOfBytesRead;
        byte[] buf = new byte[4096];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        UniversalDetector universalDetector = new UniversalDetector(null);
        while ((numberOfBytesRead = bufferedInputStream.read(buf)) > 0 && !universalDetector.isDone()) {
            universalDetector.handleData(buf, 0, numberOfBytesRead);
        }
        universalDetector.dataEnd();
        bufferedInputStream.close();
        String encoding = universalDetector.getDetectedCharset();
        if (encoding != null) {
            logger.debug("Detected encoding for {} is {}.", (Object)file.getAbsolutePath(), (Object)encoding);
        } else {
            logger.debug("No encoding detected for {}.", (Object)file.getAbsolutePath());
        }
        universalDetector.reset();
        return encoding;
    }

    public static boolean isFileUTF8(File file) throws IOException {
        return FileUtil.isCharsetUTF8(FileUtil.getFileCharset(file));
    }

    public static boolean isCharsetUTF8(String charset) {
        return org.apache.commons.lang3.StringUtils.equalsIgnoreCase(charset, Constants.CHARSET_UTF_8);
    }

    public static boolean isFileUTF16(File file) throws IOException {
        return FileUtil.isCharsetUTF16(FileUtil.getFileCharset(file));
    }

    public static boolean isCharsetUTF16(String charset) {
        return org.apache.commons.lang3.StringUtils.equalsIgnoreCase(charset, Constants.CHARSET_UTF_16LE) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase(charset, Constants.CHARSET_UTF_16BE);
    }

    public static boolean isCharsetUTF32(String charset) {
        return org.apache.commons.lang3.StringUtils.equalsIgnoreCase(charset, Constants.CHARSET_UTF_32LE) || org.apache.commons.lang3.StringUtils.equalsIgnoreCase(charset, Constants.CHARSET_UTF_32BE);
    }

    public static void convertFileFromUtf16ToUtf8(File inputFile, File outputFile) throws IOException {
        String charset;
        if (inputFile == null || !inputFile.canRead()) {
            throw new FileNotFoundException("Can't read inputFile.");
        }
        try {
            charset = FileUtil.getFileCharset(inputFile);
        }
        catch (IOException ex) {
            logger.debug("Exception during charset detection.", ex);
            throw new IllegalArgumentException("Can't confirm inputFile is UTF-16.");
        }
        if (FileUtil.isCharsetUTF16(charset)) {
            if (!outputFile.exists()) {
                int c;
                BufferedReader reader = null;
                try {
                    reader = org.apache.commons.lang3.StringUtils.equalsIgnoreCase(charset, Constants.CHARSET_UTF_16LE) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-16")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-16BE"));
                }
                catch (UnsupportedEncodingException ex) {
                    logger.warn("Unsupported exception.", ex);
                    throw ex;
                }
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
                while ((c = reader.read()) != -1) {
                    writer.write(c);
                }
                writer.close();
                reader.close();
            }
        } else {
            throw new IllegalArgumentException("File is not UTF-16");
        }
    }

    public static boolean isFileReadable(File file) {
        boolean isReadable = false;
        if (file != null && file.isFile()) {
            try {
                new FileInputStream(file).close();
                isReadable = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return isReadable;
    }

    public static boolean isFileWritable(File file) {
        boolean isWritable;
        block7: {
            boolean fileAlreadyExists;
            isWritable = false;
            if (file != null && ((fileAlreadyExists = file.isFile()) || !file.exists())) {
                try {
                    new FileOutputStream(file, true).close();
                    isWritable = true;
                    if (fileAlreadyExists) break block7;
                    try {
                        if (!file.delete()) {
                            logger.warn("Can't delete temporary test file: {}", (Object)file.getAbsolutePath());
                        }
                    }
                    catch (SecurityException se) {
                        logger.error("Error deleting temporary test file: " + file.getAbsolutePath(), se);
                    }
                }
                catch (IOException ioe) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return isWritable;
    }

    public static boolean isDirectoryReadable(File dir) {
        boolean isReadable = false;
        if (dir != null && (dir = dir.getAbsoluteFile()).isDirectory()) {
            try {
                File[] files = dir.listFiles();
                isReadable = files != null;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return isReadable;
    }

    public static boolean isDirectoryWritable(File dir) {
        boolean isWritable = false;
        if (dir != null && (dir = dir.getAbsoluteFile()).isDirectory()) {
            File file = new File(dir, String.format("pms_directory_write_test_%d_%d.tmp", System.currentTimeMillis(), Thread.currentThread().getId()));
            try {
                if (file.createNewFile()) {
                    if (FileUtil.isFileWritable(file)) {
                        isWritable = true;
                    }
                    if (!file.delete()) {
                        logger.warn("Can't delete temporary test file: {}", (Object)file.getAbsolutePath());
                    }
                }
            }
            catch (IOException ioe) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return isWritable;
    }

    public static final class FileLocation {
        private String directoryPath;
        private String filePath;

        FileLocation(File directory, File file) {
            this.directoryPath = FilenameUtils.normalize(directory.getAbsolutePath());
            this.filePath = FilenameUtils.normalize(file.getAbsolutePath());
        }

        public String getDirectoryPath() {
            return this.directoryPath;
        }

        public String getFilePath() {
            return this.filePath;
        }
    }
}

