/*
 * Decompiled with CFR 0.152.
 */
package net.pms.update;

import java.io.IOException;
import net.pms.update.OperatingSystem;
import net.pms.util.PmsProperties;
import net.pms.util.Version;

public class AutoUpdaterServerProperties {
    private static final String KEY_LATEST_VERSION = "LatestVersion";
    private static final String DEFAULT_LATEST_VERSION = "0";
    private static final String KEY_DOWNLOAD_URL = "DownloadUrl";
    private static final String DEFAULT_DOWNLOAD_URL = "";
    private final PmsProperties properties = new PmsProperties();
    private final OperatingSystem operatingSystem = new OperatingSystem();

    public void loadFrom(byte[] data) throws IOException {
        this.properties.clear();
        this.properties.loadFromByteArray(data);
    }

    public boolean isStateValid() {
        return this.getDownloadUrl().length() > 0 && this.getLatestVersion().isGreaterThan(new Version(DEFAULT_LATEST_VERSION));
    }

    public Version getLatestVersion() {
        return new Version(this.getStringWithDefault(KEY_LATEST_VERSION, DEFAULT_LATEST_VERSION));
    }

    public String getDownloadUrl() {
        return this.getStringWithDefault(KEY_DOWNLOAD_URL, DEFAULT_DOWNLOAD_URL);
    }

    private String getStringWithDefault(String key, String defaultValue) {
        String platformSpecificKey = this.getPlatformSpecificKey(key);
        if (this.properties.containsKey(platformSpecificKey)) {
            return this.properties.get(platformSpecificKey);
        }
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return defaultValue;
    }

    private String getPlatformSpecificKey(String key) {
        return key + "." + this.operatingSystem.getPlatformName();
    }
}

