/*
 * Decompiled with CFR 0.152.
 */
package net.pms.newgui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.pms.Messages;
import net.pms.configuration.PmsConfiguration;
import net.pms.logging.LoggingConfigFileLoader;
import net.pms.util.FormLayoutUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracesTab {
    private static final Logger logger = LoggerFactory.getLogger(TracesTab.class);
    private PmsConfiguration configuration;
    private JTextArea jList;
    protected JScrollPane jListPane;

    TracesTab(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public JTextArea getList() {
        return this.jList;
    }

    public void append(String msg) {
        this.getList().append(msg);
        final JScrollBar vbar = this.jListPane.getVerticalScrollBar();
        if (vbar.getMaximum() == vbar.getValue() + vbar.getVisibleAmount()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    vbar.setValue(vbar.getMaximum());
                }
            });
        }
    }

    public JComponent build() {
        Locale locale = new Locale(this.configuration.getLanguage());
        ComponentOrientation orientation = ComponentOrientation.getOrientation(locale);
        String colSpec = FormLayoutUtil.getColSpec("left:pref, 10:grow", orientation);
        FormLayout layout = new FormLayout(colSpec, "fill:10:grow, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setOpaque(true);
        CellConstraints cc = new CellConstraints();
        this.jList = new JTextArea();
        this.jList.setEditable(false);
        this.jList.setBackground(Color.WHITE);
        this.jList.setFont(new Font("Monospaced", 0, 12));
        JPopupMenu popup = new JPopupMenu();
        JMenuItem defaultItem = new JMenuItem(Messages.getString("TracesTab.3"));
        defaultItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracesTab.this.jList.setText("");
            }
        });
        popup.add(defaultItem);
        this.jList.addMouseListener(new PopupTriggerMouseListener(popup, this.jList));
        this.jListPane = new JScrollPane(this.jList, 22, 30);
        builder.add((Component)this.jListPane, cc.xyw(1, 1, 2));
        JPanel pLogfileButtons = new JPanel(new FlowLayout(2));
        HashMap<String, String> logfiles = LoggingConfigFileLoader.getLogFilePaths();
        for (String loggerName : logfiles.keySet()) {
            JButton b = new JButton(loggerName);
            b.setToolTipText(logfiles.get(loggerName));
            b.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    File logfile = new File(((JButton)e.getSource()).getToolTipText());
                    try {
                        Desktop.getDesktop().open(logfile);
                    }
                    catch (IOException ioe) {
                        logger.error(String.format("Failed to open file %s in default editor", logfile), ioe);
                    }
                    catch (UnsupportedOperationException usoe) {
                        logger.error(String.format("Failed to open file %s in default editor", logfile), usoe);
                    }
                }
            });
            pLogfileButtons.add(b);
        }
        builder.add((Component)pLogfileButtons, cc.xy(2, 2));
        return builder.getPanel();
    }

    class PopupTriggerMouseListener
    extends MouseAdapter {
        private JPopupMenu popup;
        private JComponent component;

        public PopupTriggerMouseListener(JPopupMenu popup, JComponent component) {
            this.popup = popup;
            this.component = component;
        }

        private void showMenuIfPopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(this.component, e.getX() + 3, e.getY() + 3);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showMenuIfPopupTrigger(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showMenuIfPopupTrigger(e);
        }
    }
}

