/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.FFmpegOptions;
import net.pms.encoders.FFmpegProtocols;
import net.pms.encoders.FFmpegVideo;
import net.pms.encoders.PlayerPurpose;
import net.pms.io.OutputParams;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.PlayerUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegWebVideo
extends FFmpegVideo {
    private static final Logger logger = LoggerFactory.getLogger(FFmpegWebVideo.class);
    private final PmsConfiguration configuration;
    private final FFmpegProtocols protocols;
    @Deprecated
    public static final String ID = "ffmpegwebvideo";

    public FFmpegWebVideo(PmsConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
        this.protocols = this.getProtocols();
    }

    @Deprecated
    public FFmpegWebVideo(PmsConfiguration configuration, FFmpegProtocols protocols) {
        this(configuration);
    }

    @Override
    public JComponent config() {
        return null;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_WEB_STREAM_PLAYER;
    }

    @Override
    public boolean isTimeSeekable() {
        return false;
    }

    @Override
    public synchronized ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        params.minBufferSize = params.minFileSize;
        params.secondread_minsize = 100000;
        params.waitbeforestart = 6000;
        RendererConfiguration renderer = params.mediaRenderer;
        String filename = this.protocols.getFilename(dlna.getSystemName());
        FFmpegOptions customOptions = new FFmpegOptions();
        if (params.header != null && params.header.length > 0) {
            String hdr = new String(params.header);
            customOptions.addAll((List)FFmpegWebVideo.parseOptions(hdr));
        }
        if (StringUtils.isNotEmpty(renderer.getCustomFFmpegOptions())) {
            customOptions.addAll((List)FFmpegWebVideo.parseOptions(renderer.getCustomFFmpegOptions()));
        }
        String fifoName = String.format("ffmpegwebvideo_%d_%d", Thread.currentThread().getId(), System.currentTimeMillis());
        PipeProcess pipe = new PipeProcess(fifoName, new String[0]);
        pipe.deleteLater();
        ProcessWrapper mkfifo_process = pipe.getPipeProcess();
        mkfifo_process.runInNewThread();
        params.input_pipes[0] = pipe;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.executable());
        cmdList.addAll(this.getGlobalOptions(logger));
        int nThreads = this.configuration.getNumberOfCpuCores();
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        if (!customOptions.isEmpty()) {
            customOptions.transferGlobals(cmdList);
            customOptions.transferInputFileOptions(cmdList);
        }
        cmdList.add("-i");
        cmdList.add(filename);
        cmdList.addAll(this.getVideoFilterOptions(dlna, media, params));
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        cmdList.addAll(this.getVideoTranscodeOptions(dlna, media, params));
        cmdList.addAll(this.getVideoBitrateOptions(dlna, media, params));
        cmdList.addAll(this.getAudioBitrateOptions(dlna, media, params));
        if (!customOptions.isEmpty()) {
            customOptions.transferAll(cmdList);
        }
        cmdList.add(pipe.getInputPipe());
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.attachProcess(mkfifo_process);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted while waiting for named pipe to be created", e);
        }
        pw.runInNewThread();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted while waiting for transcode to start", e);
        }
        return pw;
    }

    @Override
    public String name() {
        return "FFmpeg Web Video";
    }

    @Override
    @Deprecated
    public String[] args() {
        return null;
    }

    @Override
    public boolean isCompatible(DLNAResource dlna) {
        if (!PlayerUtil.isWebVideo(dlna)) {
            return false;
        }
        String protocol = dlna.getFormat().getMatchedExtension();
        return this.protocols.isSupportedProtocol(protocol);
    }
}

