/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.util.ArrayList;
import java.util.List;
import net.pms.configuration.PmsConfiguration;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FFmpegProtocols {
    private final Logger logger = LoggerFactory.getLogger(FFmpegProtocols.class);
    private final List<String> protocols = new ArrayList<String>();
    private final PmsConfiguration configuration;
    private boolean convertMmsToMmsh = false;

    FFmpegProtocols(PmsConfiguration configuration) {
        this.configuration = configuration;
        this.queryProtocols();
        if (!this.protocols.contains("mms") && this.protocols.contains("mmsh")) {
            this.protocols.add("mms");
            this.convertMmsToMmsh = true;
        }
        this.logger.debug("FFmpeg supported protocols: {}", (Object)this.protocols);
    }

    public boolean isSupportedProtocol(String protocol) {
        return this.protocols.contains(protocol);
    }

    public String getFilename(String filename) {
        if (this.convertMmsToMmsh && filename.startsWith("mms:")) {
            filename = "mmsh:" + filename.substring(4);
        }
        return filename;
    }

    private void queryProtocols() {
        String output = ProcessUtil.run(this.configuration.getFfmpegPath(), "-protocols");
        boolean add = false;
        for (String line : output.split("\n")) {
            if (line.equals("Input:")) {
                add = true;
                continue;
            }
            if (line.equals("Output:")) break;
            if (!add) continue;
            this.protocols.add(line);
        }
    }
}

