/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.sun.jna.FunctionMapper;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.lang.reflect.Method;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaInfo {
    private static final Logger logger = LoggerFactory.getLogger(MediaInfo.class);
    static String libraryName = Platform.isWindows() && Platform.is64Bit() ? "mediainfo64" : "mediainfo";
    private Pointer Handle;

    public MediaInfo() {
        try {
            logger.info("Loading MediaInfo library");
            this.Handle = MediaInfoDLL_Internal.INSTANCE.New();
            logger.info("Loaded " + MediaInfo.Option_Static("Info_Version"));
        }
        catch (Throwable e) {
            if (e != null) {
                logger.info("Error loading MediaInfo library: " + e.getMessage());
            }
            if (!Platform.isWindows() && !Platform.isMac()) {
                logger.info("Make sure you have libmediainfo and libzen installed");
            }
            logger.info("The server will now use the less accurate FFmpeg parsing method");
        }
    }

    public boolean isValid() {
        return this.Handle != null;
    }

    public void dispose() {
        if (this.Handle == null) {
            throw new IllegalStateException();
        }
        MediaInfoDLL_Internal.INSTANCE.Delete(this.Handle);
        this.Handle = null;
    }

    protected void finalize() throws Throwable {
        if (this.Handle != null) {
            this.dispose();
        }
    }

    public int Open(String fileName) {
        return MediaInfoDLL_Internal.INSTANCE.Open(this.Handle, new WString(fileName));
    }

    public void Close() {
        MediaInfoDLL_Internal.INSTANCE.Close(this.Handle);
    }

    public String Inform() {
        return MediaInfoDLL_Internal.INSTANCE.Inform(this.Handle).toString();
    }

    public String Get(StreamType streamType, int streamNumber, String parameter) {
        return this.Get(streamType, streamNumber, parameter, InfoType.Text, InfoType.Name);
    }

    public String Get(StreamType streamType, int streamNumber, String parameter, InfoType infoType) {
        return this.Get(streamType, streamNumber, parameter, infoType, InfoType.Name);
    }

    public String Get(StreamType streamType, int streamNumber, String parameter, InfoType infoType, InfoType searchType) {
        return MediaInfoDLL_Internal.INSTANCE.Get(this.Handle, streamType.ordinal(), streamNumber, new WString(parameter), infoType.ordinal(), searchType.ordinal()).toString();
    }

    public String get(StreamType streamType, int streamNumber, int parameterIndex) {
        return this.Get(streamType, streamNumber, parameterIndex, InfoType.Text);
    }

    public String Get(StreamType streamType, int streamNumber, int parameterIndex, InfoType infoType) {
        return MediaInfoDLL_Internal.INSTANCE.GetI(this.Handle, streamType.ordinal(), streamNumber, parameterIndex, infoType.ordinal()).toString();
    }

    public int Count_Get(StreamType streamType) {
        return MediaInfoDLL_Internal.INSTANCE.Count_Get(this.Handle, streamType.ordinal(), -1);
    }

    public int Count_Get(StreamType streamType, int streamNumber) {
        return MediaInfoDLL_Internal.INSTANCE.Count_Get(this.Handle, streamType.ordinal(), streamNumber);
    }

    public String Option(String option) {
        return MediaInfoDLL_Internal.INSTANCE.Option(this.Handle, new WString(option), new WString("")).toString();
    }

    public String Option(String option, String value) {
        return MediaInfoDLL_Internal.INSTANCE.Option(this.Handle, new WString(option), new WString(value)).toString();
    }

    public static String Option_Static(String option) {
        return MediaInfoDLL_Internal.INSTANCE.Option(MediaInfoDLL_Internal.INSTANCE.New(), new WString(option), new WString("")).toString();
    }

    public static String Option_Static(String option, String value) {
        return MediaInfoDLL_Internal.INSTANCE.Option(MediaInfoDLL_Internal.INSTANCE.New(), new WString(option), new WString(value)).toString();
    }

    static {
        if (!Platform.isWindows() && !Platform.isMac()) {
            try {
                NativeLibrary.getInstance("zen");
            }
            catch (LinkageError e) {
                logger.warn("Error loading libzen: " + e.getMessage());
            }
        }
    }

    public static enum InfoType {
        Name,
        Text,
        Measure,
        Options,
        Name_Text,
        Measure_Text,
        Info,
        HowTo,
        Domain;

    }

    @Deprecated
    public static enum InfoKind {
        Name,
        Text,
        Measure,
        Options,
        Name_Text,
        Measure_Text,
        Info,
        HowTo,
        Domain;

    }

    public static enum StreamType {
        General,
        Video,
        Audio,
        Text,
        Chapters,
        Image,
        Menu;

    }

    @Deprecated
    public static enum StreamKind {
        General,
        Video,
        Audio,
        Text,
        Chapters,
        Image,
        Menu;

    }

    static interface MediaInfoDLL_Internal
    extends Library {
        public static final MediaInfoDLL_Internal INSTANCE = (MediaInfoDLL_Internal)Native.loadLibrary(libraryName, MediaInfoDLL_Internal.class, Collections.singletonMap("function-mapper", new FunctionMapper(){

            @Override
            public String getFunctionName(NativeLibrary lib, Method method) {
                return "MediaInfo_" + method.getName();
            }
        }));

        public Pointer New();

        public void Delete(Pointer var1);

        public int Open(Pointer var1, WString var2);

        public void Close(Pointer var1);

        public WString Inform(Pointer var1);

        public WString Get(Pointer var1, int var2, int var3, WString var4, int var5, int var6);

        public WString GetI(Pointer var1, int var2, int var3, int var4, int var5);

        public int Count_Get(Pointer var1, int var2, int var3);

        public WString Option(Pointer var1, WString var2, WString var3);
    }
}

